<?php

namespace App\Events;

use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ChatMessageSent implements ShouldBroadcast
{
    use Dispatchable, SerializesModels;

    public $chatRoomId;
    public $message;

    public function __construct($chatRoomId, $message)
    {
        $this->chatRoomId = $chatRoomId;
        $this->message = $message;
    }

    public function broadcastOn()
    {
        return new PrivateChannel('chat.' . $this->chatRoomId);
    }

    public function broadcastWith()
    {
        return [
            'chatRoomId' => $this->chatRoomId,
            'message' => $this->message,
        ];
    }
}
