<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CooperationRequest;
use Illuminate\Http\Request;

class CooperationRequestController extends Controller
{
    public function index()
    {
        $requests = CooperationRequest::orderByDesc('created_at')->paginate(20);
        return view('admin.cooperation_requests.index', compact('requests'));
    }

    public function show($id)
    {
        $request = \App\Models\CooperationRequest::findOrFail($id);
        return view('admin.cooperation_requests.show', compact('request'));
    }

    public function approve($id)
    {
        $request = CooperationRequest::findOrFail($id);
        $request->status = 'approved';
        $request->save();
        return redirect()->route('admin.cooperation-requests.show', $id)->with('success', 'Request approved.');
    }

    public function reject($id)
    {
        $request = CooperationRequest::findOrFail($id);
        $request->status = 'rejected';
        $request->save();
        return redirect()->route('admin.cooperation-requests.show', $id)->with('success', 'Request rejected.');
    }
}
