<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Product;
use App\Models\User;
use App\Models\ChatRoom;
use App\Services\ChatFileService;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_orders' => Order::count(),
            'total_products' => Product::count(),
            'total_users' => User::count(),
            'recent_orders' => Order::with(['user', 'items.product'])
                ->latest()
                ->take(5)
                ->get(),
        ];

        // محاسبه چت‌های آزاد و پیام‌های خوانده‌نشده دقیقاً مثل API
        $adminId = auth('admin')->id();
        $availableChats = ChatRoom::where('admin_id', null)->where('is_active', true)->count();
        $myChats = ChatRoom::where('admin_id', $adminId)->where('is_active', true)->get();
        $totalUnreadMessages = 0;
        foreach ($myChats as $chat) {
            $messages = app(ChatFileService::class)->getMessages($chat->id);
            $unread = collect($messages)
                ->filter(function($msg) {
                    return isset($msg['sender_type'], $msg['is_read'])
                        && $msg['sender_type'] === 'user'
                        && ($msg['is_read'] === false || $msg['is_read'] === 0 || $msg['is_read'] === '0' || $msg['is_read'] === 'false');
                })
                ->count();
            $totalUnreadMessages += $unread;
        }
        $myUnreadChats = $myChats->filter(function($chat) {
            $messages = app(ChatFileService::class)->getMessages($chat->id);
            return collect($messages)
                ->filter(function($msg) {
                    return isset($msg['sender_type'], $msg['is_read'])
                        && $msg['sender_type'] === 'user'
                        && ($msg['is_read'] === false || $msg['is_read'] === 0 || $msg['is_read'] === '0' || $msg['is_read'] === 'false');
                })->count() > 0;
        })->count();

        return view('admin.dashboard', compact('stats', 'availableChats', 'myUnreadChats', 'totalUnreadMessages'));
    }
}
