<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Review;
use Illuminate\Http\Request;

class ReviewController extends Controller
{
    public function index()
    {
        $reviews = Review::with(['user', 'product'])
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        return view('admin.reviews.index', compact('reviews'));
    }

    public function pending()
    {
        $reviews = Review::with(['user', 'product'])
            ->where('is_approved', false)
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        return view('admin.reviews.pending', compact('reviews'));
    }

    public function approved()
    {
        $reviews = Review::with(['user', 'product'])
            ->where('is_approved', true)
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        return view('admin.reviews.approved', compact('reviews'));
    }

    public function approve(Review $review)
    {
        $review->update(['is_approved' => true]);

        // Update product rating
        $review->product->updateRatingFromReviews();

        return redirect()->back()->with('success', 'Review approved successfully.');
    }

    public function reject(Review $review)
    {
        $review->update(['is_approved' => false]);

        // Update product rating
        $review->product->updateRatingFromReviews();

        return redirect()->back()->with('success', 'Review rejected successfully.');
    }

    public function destroy(Review $review)
    {
        $product = $review->product;
        $review->delete();

        // Update product rating
        $product->updateRatingFromReviews();

        return redirect()->back()->with('success', 'Review deleted successfully.');
    }

    public function show(Review $review)
    {
        $review->load(['user', 'product']);
        return view('admin.reviews.show', compact('review'));
    }
}

