<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function index()
    {
        $taxRate = Setting::getTaxRate();
        $mail_settings = [
            'mail_mailer' => Setting::getValue('mail_mailer', 'smtp'),
            'mail_host' => Setting::getValue('mail_host', ''),
            'mail_port' => Setting::getValue('mail_port', ''),
            'mail_encryption' => Setting::getValue('mail_encryption', ''),
            'mail_username' => Setting::getValue('mail_username', ''),
            'mail_password' => Setting::getValue('mail_password', ''),
            'mail_from_address' => Setting::getValue('mail_from_address', ''),
            'mail_from_name' => Setting::getValue('mail_from_name', ''),
        ];
        $all_gateways = [
            'paypal' => 'PayPal',
            'stripe' => 'Stripe',
            'nowpayments' => 'NOWPayments',
            'bitpay' => 'BitPay',
            'coingate' => 'Coingate',
            'payoneer' => 'Payoneer',
            'wise' => 'Wise',
        ];
        $enabled_gateways = Setting::getValue('enabled_gateways', []);
        $gateway_tokens = [
            'paypal' => Setting::getValue('gateway_token_paypal', ''),
            'stripe' => Setting::getValue('gateway_token_stripe', ''),
            'nowpayments' => Setting::getValue('gateway_token_nowpayments', ''),
            'bitpay' => Setting::getValue('gateway_token_bitpay', ''),
            'coingate' => Setting::getValue('gateway_token_coingate', ''),
            'payoneer' => Setting::getValue('gateway_token_payoneer', ''),
            'wise' => Setting::getValue('gateway_token_wise', ''),
        ];
        $gateway_fields = [
            'paypal' => [
                'client_id' => Setting::getValue('gateway_paypal_client_id', ''),
                'client_secret' => Setting::getValue('gateway_paypal_client_secret', ''),
                'mode' => Setting::getValue('gateway_paypal_mode', 'sandbox'),
            ],
            'stripe' => [
                'publishable_key' => Setting::getValue('gateway_stripe_publishable_key', ''),
                'secret_key' => Setting::getValue('gateway_stripe_secret_key', ''),
                'webhook_secret' => Setting::getValue('gateway_stripe_webhook_secret', ''),
            ],
            'nowpayments' => [
                'api_key' => Setting::getValue('gateway_nowpayments_api_key', ''),
                'ipn_secret' => Setting::getValue('gateway_nowpayments_ipn_secret', ''),
            ],
            'bitpay' => [
                'api_token' => Setting::getValue('gateway_bitpay_api_token', ''),
                'pairing_code' => Setting::getValue('gateway_bitpay_pairing_code', ''),
                'environment' => Setting::getValue('gateway_bitpay_environment', 'test'),
            ],
            'coingate' => [
                'api_key' => Setting::getValue('gateway_coingate_api_key', ''),
                'api_secret' => Setting::getValue('gateway_coingate_api_secret', ''),
                'environment' => Setting::getValue('gateway_coingate_environment', 'sandbox'),
            ],
            'payoneer' => [
                'client_id' => Setting::getValue('gateway_payoneer_client_id', ''),
                'client_secret' => Setting::getValue('gateway_payoneer_client_secret', ''),
                'partner_id' => Setting::getValue('gateway_payoneer_partner_id', ''),
                'api_url' => Setting::getValue('gateway_payoneer_api_url', ''),
            ],
            'wise' => [
                'api_token' => Setting::getValue('gateway_wise_api_token', ''),
                'profile_id' => Setting::getValue('gateway_wise_profile_id', ''),
                'environment' => Setting::getValue('gateway_wise_environment', 'sandbox'),
            ],
        ];
        $settings = [
            'contact_email' => Setting::getValue('contact_email', ''),
            'contact_phone' => Setting::getValue('contact_phone', ''),
            'contact_address' => Setting::getValue('contact_address', ''),
            'contact_telegram' => Setting::getValue('contact_telegram', ''),
            'contact_instagram' => Setting::getValue('contact_instagram', ''),
            'contact_facebook' => Setting::getValue('contact_facebook', ''),
            'contact_twitter' => Setting::getValue('contact_twitter', ''),
        ];
        return view('admin.settings.index', compact('taxRate', 'mail_settings', 'all_gateways', 'enabled_gateways', 'gateway_tokens', 'gateway_fields', 'settings'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'tax_rate' => 'required|numeric|min:0|max:100',
            'mail_mailer' => 'required|string',
            'mail_host' => 'required|string',
            'mail_port' => 'required|numeric',
            'mail_encryption' => 'nullable|string',
            'mail_username' => 'nullable|string',
            'mail_password' => 'nullable|string',
            'mail_from_address' => 'required|email',
            'mail_from_name' => 'required|string',
            'enabled_gateways' => 'nullable|array',
        ]);
        $taxRate = $request->tax_rate / 100;
        Setting::setTaxRate($taxRate);
        Setting::setValue('mail_mailer', $request->mail_mailer);
        Setting::setValue('mail_host', $request->mail_host);
        Setting::setValue('mail_port', $request->mail_port);
        Setting::setValue('mail_encryption', $request->mail_encryption);
        Setting::setValue('mail_username', $request->mail_username);
        Setting::setValue('mail_password', $request->mail_password);
        Setting::setValue('mail_from_address', $request->mail_from_address);
        Setting::setValue('mail_from_name', $request->mail_from_name);
        // Save enabled gateways and their tokens
        $enabled_gateways = $request->enabled_gateways ?? [];
        Setting::setValue('enabled_gateways', $enabled_gateways, 'json');
        $gateway_tokens = [
            'paypal' => $request->gateway_token_paypal,
            'stripe' => $request->gateway_token_stripe,
            'nowpayments' => $request->gateway_token_nowpayments,
            'bitpay' => $request->gateway_token_bitpay,
            'coingate' => $request->gateway_token_coingate,
            'payoneer' => $request->gateway_token_payoneer,
            'wise' => $request->gateway_token_wise,
        ];
        foreach ($gateway_tokens as $key => $token) {
            Setting::setValue('gateway_token_' . $key, $token);
        }
        // Save all gateway fields
        $gateway_fields_post = [
            'paypal' => [
                'client_id' => $request->gateway_paypal_client_id,
                'client_secret' => $request->gateway_paypal_client_secret,
                'mode' => $request->gateway_paypal_mode,
            ],
            'stripe' => [
                'publishable_key' => $request->gateway_stripe_publishable_key,
                'secret_key' => $request->gateway_stripe_secret_key,
                'webhook_secret' => $request->gateway_stripe_webhook_secret,
            ],
            'nowpayments' => [
                'api_key' => $request->gateway_nowpayments_api_key,
                'ipn_secret' => $request->gateway_nowpayments_ipn_secret,
            ],
            'bitpay' => [
                'api_token' => $request->gateway_bitpay_api_token,
                'pairing_code' => $request->gateway_bitpay_pairing_code,
                'environment' => $request->gateway_bitpay_environment,
            ],
            'coingate' => [
                'api_key' => $request->gateway_coingate_api_key,
                'api_secret' => $request->gateway_coingate_api_secret,
                'environment' => $request->gateway_coingate_environment,
            ],
            'payoneer' => [
                'client_id' => $request->gateway_payoneer_client_id,
                'client_secret' => $request->gateway_payoneer_client_secret,
                'partner_id' => $request->gateway_payoneer_partner_id,
                'api_url' => $request->gateway_payoneer_api_url,
            ],
            'wise' => [
                'api_token' => $request->gateway_wise_api_token,
                'profile_id' => $request->gateway_wise_profile_id,
                'environment' => $request->gateway_wise_environment,
            ],
        ];
        foreach ($gateway_fields_post as $gateway => $fields) {
            foreach ($fields as $field => $value) {
                Setting::setValue('gateway_' . $gateway . '_' . $field, $value);
            }
        }
        // Save contact & social fields
        Setting::setValue('contact_email', $request->contact_email);
        Setting::setValue('contact_phone', $request->contact_phone);
        Setting::setValue('contact_address', $request->contact_address);
        Setting::setValue('contact_telegram', $request->contact_telegram);
        Setting::setValue('contact_instagram', $request->contact_instagram);
        Setting::setValue('contact_facebook', $request->contact_facebook);
        Setting::setValue('contact_twitter', $request->contact_twitter);
        return redirect()->back()->with('success', 'Settings updated successfully.');
    }
}
