<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use App\Models\Page;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ContactController extends Controller
{
    public function index()
    {
        // Get only SEO information from pages table where slug = 'contact'
        $page = Page::where('slug', 'contact')
                   ->where('is_active', true)
                   ->select([
                       'meta_title',
                       'meta_description',
                       'meta_keywords',
                       'og_title',
                       'og_description',
                       'og_image',
                       'twitter_title',
                       'twitter_description',
                       'twitter_image',
                       'canonical_url',
                       'robots_directive',
                       'seo_priority',
                       'seo_indexable',
                       'show_in_sitemap'
                   ])
                   ->first();

        return view('contact', compact('page'));
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'subject' => 'required|string|max:255',
            'message' => 'required|string|max:1000',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        // Check if user has already submitted a contact form
        if (Contact::hasUserSubmitted($request->email)) {
            return back()->withErrors(['email' => 'You have already submitted a contact form. Please wait for our response.'])->withInput();
        }

        // Create contact message
        Contact::create([
            'name' => $request->name,
            'email' => $request->email,
            'subject' => $request->subject,
            'message' => $request->message,
            'is_read' => false,
        ]);

        return back()->with('success', 'Your message has been sent successfully! We will get back to you soon.');
    }
}
