<?php

namespace App\Http\Controllers;

abstract class Controller
{
    public static function getTotalUnreadAdminChats()
    {
        return \App\Models\ChatRoom::all()->reduce(function($carry, $c) {
            return $carry + $c->messages()->where('sender_type', 'user')->where('is_read', false)->count();
        }, 0);
    }

    public static function getTotalUnreadUserChats($userId)
    {
        $chats = \App\Models\ChatRoom::where('user_id', $userId)->get();
        $total = 0;
        foreach ($chats as $chat) {
            $messages = app(\App\Services\ChatFileService::class)->getMessages($chat->id);
            foreach ($messages as $msg) {
                if (
                    isset($msg['sender_type'], $msg['is_read']) &&
                    $msg['sender_type'] === 'admin' &&
                    (
                        $msg['is_read'] === false ||
                        $msg['is_read'] === 0 ||
                        $msg['is_read'] === '0' ||
                        $msg['is_read'] === 'false'
                    ) &&
                    isset($msg['chat_room_id']) && $msg['chat_room_id'] == $chat->id
                ) {
                    $total++;
                }
            }
        }
        return $total;
    }
}
