<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CooperationRequest;
use Illuminate\Support\Facades\Auth;

class CooperationController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $pendingRequest = null;
        if ($user) {
            $pendingRequest = CooperationRequest::where('user_id', $user->id)->where('status', 'pending')->first();
        }
        return view('cooperation.index', compact('pendingRequest'));
    }

    public function store(Request $request)
    {
        $user = Auth::user();
        $type = $request->input('type');
        // جلوگیری از ثبت مجدد تا زمان بررسی
        if ($user) {
            $exists = CooperationRequest::where('user_id', $user->id)->where('type', $type)->where('status', 'pending')->exists();
            if ($exists) {
                return response()->json(['message' => 'You already have a pending request for this cooperation type.'], 422);
            }
        } else {
            $email = $request->input('email');
            $exists = CooperationRequest::where('email', $email)->where('type', $type)->where('status', 'pending')->exists();
            if ($exists) {
                return response()->json(['message' => 'You already have a pending request for this cooperation type.'], 422);
            }
        }
        $data = $request->all();
        if ($user) {
            $data['user_id'] = $user->id;
        }
        $data['status'] = 'pending';
        CooperationRequest::create($data);
        return response()->json(['message' => 'Your request has been submitted and is pending review.'], 200);
    }
}
