<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Models\Product;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $recentOrders = Order::where('user_id', auth()->id())
            ->latest()
            ->take(5)
            ->get();

        $totalProducts = Product::where('user_id', auth()->id())->count();
        $lowStockProducts = Product::where('user_id', auth()->id())
            ->where('stock', '<', 10)
            ->count();
        $featuredProducts = Product::where('user_id', auth()->id())
            ->where('is_featured', true)
            ->count();

        return view('dashboard', compact(
            'recentOrders',
            'totalProducts',
            'lowStockProducts',
            'featuredProducts'
        ));
    }
}
