<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Services\InvoiceService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class InvoiceController extends Controller
{
    protected $invoiceService;

    public function __construct(InvoiceService $invoiceService)
    {
        $this->invoiceService = $invoiceService;
    }

    public function show($orderId)
    {
        // Check if user owns this order
        $order = Order::where('id', $orderId)
                     ->where('user_id', Auth::id())
                     ->first();

        if (!$order) {
            abort(404, 'Order not found or access denied.');
        }

        // Generate invoice data (works for all order statuses)
        $invoiceData = $this->invoiceService->getInvoiceData($orderId);

        if (!$invoiceData) {
            return redirect()->back()->with('error', 'Failed to generate invoice.');
        }

        return view('orders.invoice', compact('invoiceData'));
    }

    public function download($orderId)
    {
        // Check if user owns this order
        $order = Order::where('id', $orderId)
                     ->where('user_id', Auth::id())
                     ->first();

        if (!$order) {
            abort(404, 'Order not found or access denied.');
        }

        // Generate invoice data (works for all order statuses)
        $invoiceData = $this->invoiceService->getInvoiceData($orderId);

        if (!$invoiceData) {
            return redirect()->back()->with('error', 'Failed to generate invoice.');
        }

        // For now, we'll redirect to the invoice view with print parameter
        // In the future, you can implement PDF generation here
        return view('orders.invoice', compact('invoiceData'));
    }

    public function resendEmail($orderId)
    {
        // Check if user owns this order
        $order = Order::where('id', $orderId)
                     ->where('user_id', Auth::id())
                     ->first();

        if (!$order) {
            abort(404, 'Order not found or access denied.');
        }

        // Send invoice email (works for all order statuses)
        $success = $this->invoiceService->sendInvoiceEmail($order);

        if ($success) {
            return redirect()->back()->with('success', 'Invoice email sent successfully.');
        } else {
            return redirect()->back()->with('error', 'Failed to send invoice email.');
        }
    }
}
