<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use App\Models\NewsletterSubscriber;

class NewsletterController extends Controller
{
    public function subscribe(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email|max:255',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        // Store email in the database if not already subscribed
        $subscriber = NewsletterSubscriber::firstOrCreate([
            'email' => $request->email
        ]);

        session()->flash('newsletter_success', 'Thank you for subscribing to our newsletter!');

        return back()->with('success', 'Thank you for subscribing to our newsletter!');
    }

    // Send notification to all subscribers
    public static function notifySubscribers($subject, $message)
    {
        $subscribers = NewsletterSubscriber::all();
        foreach ($subscribers as $subscriber) {
            \Mail::raw($message, function ($mail) use ($subscriber, $subject) {
                $mail->to($subscriber->email)
                    ->subject($subject);
            });
        }
    }
}
