<?php

namespace App\Http\Controllers;

use App\Models\Page;
use Illuminate\Http\Request;

class PageController extends Controller
{
    public function show($slug)
    {
        $page = Page::where('slug', $slug)->where('is_active', true)->firstOrFail();

        // Prepare SEO data
        $seo = [
            'title' => $page->meta_title ?: $page->title,
            'meta_description' => $page->meta_description,
            'meta_keywords' => $page->meta_keywords,
            'og_title' => $page->og_title ?: $page->meta_title ?: $page->title,
            'og_description' => $page->og_description ?: $page->meta_description,
            'og_image' => $page->og_image,
            'twitter_title' => $page->twitter_title ?: $page->meta_title ?: $page->title,
            'twitter_description' => $page->twitter_description ?: $page->meta_description,
            'twitter_image' => $page->twitter_image,
            'canonical_url' => $page->canonical_url ?: url()->current(),
            'robots_directive' => $page->robots_directive ?: 'index,follow',
        ];

        return view('pages.show', compact('page', 'seo'));
    }
}
