<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Services\InvoiceService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class PaymentController extends Controller
{
    protected $invoiceService;

    public function __construct(InvoiceService $invoiceService)
    {
        $this->invoiceService = $invoiceService;
    }

    public function showCryptoPayment()
    {
        if (!session()->has('crypto_payment')) {
            return redirect()->route('checkout.index')
                ->with('error', 'No active crypto payment found.');
        }

        return view('payment.crypto');
    }

    public function cryptoCallback(Request $request)
    {
        Log::info('Crypto payment callback received', $request->all());

        $paymentId = $request->input('payment_id');
        $orderId = $request->input('order_id');
        $status = $request->input('payment_status');

        $order = Order::find($orderId);

        if (!$order) {
            Log::error('Order not found for crypto payment', ['order_id' => $orderId]);
            return response()->json(['error' => 'Order not found'], 404);
        }

        if ($status === 'confirmed') {
            $order->update([
                'status' => 'completed',
                'payment_status' => 'completed'
            ]);
            $this->invoiceService->sendInvoiceEmail($order);
        } elseif ($status === 'failed') {
            $order->update([
                'status' => 'failed',
                'payment_status' => 'failed'
            ]);
        }

        return response()->json(['success' => true]);
    }
}
