<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Review;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class ReviewController extends Controller
{
    use AuthorizesRequests;

    public function store(Request $request, Product $product)
    {
        $this->authorize('create', Review::class);

        $validated = $request->validate([
            'rating' => 'required|integer|min:1|max:5',
            'comment' => 'required|string|max:1000',
        ]);

        $review = new Review($validated);
        $review->user_id = auth()->id();
        $review->product_id = $product->id;
        $review->is_approved = false; // Require admin approval
        $review->save();

        return redirect()->back()->with('success', 'Review submitted and awaiting admin approval.');
    }

    public function destroy(Review $review)
    {
        $this->authorize('delete', $review);

        $review->delete();

        return redirect()->back()->with('success', 'Review deleted successfully.');
    }
}
