<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\Http\Request;

class SitemapController extends Controller
{
    public function index()
    {
        $urls = [
            [
                'loc' => route('sitemap.categories'),
                'lastmod' => now()->toAtomString(),
            ],
            [
                'loc' => route('sitemap.products'),
                'lastmod' => now()->toAtomString(),
            ],
            [
                'loc' => route('sitemap.pages'),
                'lastmod' => now()->toAtomString(),
            ],
        ];
        $xml = view('sitemap.index', compact('urls'))->render();
        return response($xml, 200)->header('Content-Type', 'application/xml');
    }

    public function categories()
    {
        $categories = \App\Models\Category::where('show_in_sitemap', true)->get();
        $urls = [];
        foreach ($categories as $category) {
            $urls[] = [
                'loc' => route('products.index', ['category' => $category->id]),
                'priority' => '0.8',
                'changefreq' => 'weekly',
            ];
        }
        $xml = view('sitemap.xml', compact('urls'))->render();
        return response($xml, 200)->header('Content-Type', 'application/xml');
    }

    public function products()
    {
        $products = \App\Models\Product::where('is_approved', true)->get();
        $urls = [];
        foreach ($products as $product) {
            $urls[] = [
                'loc' => route('products.show', $product->id),
                'priority' => '0.7',
                'changefreq' => 'weekly',
            ];
        }
        $xml = view('sitemap.xml', compact('urls'))->render();
        return response($xml, 200)->header('Content-Type', 'application/xml');
    }

    public function pages()
    {
        $pages = \App\Models\Page::where('is_active', true)->where('show_in_sitemap', true)->get();
        $urls = [];
        foreach ($pages as $page) {
            $urls[] = [
                'loc' => route('pages.show.public', $page->slug),
                'priority' => '0.7',
                'changefreq' => 'monthly',
            ];
        }
        $xml = view('sitemap.xml', compact('urls'))->render();
        return response($xml, 200)->header('Content-Type', 'application/xml');
    }
}
