<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckAdminPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string  $permission
     * @return mixed
     */
    public function handle(Request $request, Closure $next, $permission)
    {
        /** @var \App\Models\Admin $admin */
        $admin = auth('admin')->user();
        if (!$admin) {
            abort(403);
        }
        if (!$admin->hasRole('full_access') && !$admin->hasRole($permission)) {
            abort(403);
        }
        return $next($request);
    }
}
