<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PreventAdminAccess
{
    public function handle(Request $request, Closure $next)
    {
        // If user is admin, they cannot access user routes
        if (Auth::guard('admin')->check()) {
            if ($request->expectsJson()) {
                return response()->json(['error' => 'Admin cannot access user routes'], 403);
            }
            return redirect()->route('admin.dashboard')->with('error', 'Admins cannot access user areas');
        }

        return $next($request);
    }
}
 