<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Admin extends Authenticatable
{
    use Notifiable;

    protected $guard = 'admin';

    protected $fillable = [
        'name',
        'email',
        'password',
        'role_id',
        'is_active',
        'roles',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'is_active' => 'boolean',
        'roles' => 'array',
    ];

    // public function role()
    // {
    //     return $this->belongsTo(Role::class);
    // }

    // public function hasPermission($permission)
    // {
    //     if (!$this->role) {
    //         return false;
    //     }

    //     return $this->role->hasPermission($permission);
    // }

    // public function hasAnyPermission($permissions)
    // {
    //     if (!$this->role) {
    //         return false;
    //     }

    //     return $this->role->hasAnyPermission($permissions);
    // }

    // public function hasAllPermissions($permissions)
    // {
    //     if (!$this->role) {
    //         return false;
    //     }

    //     return $this->role->hasAllPermissions($permissions);
    // }

    // public function isSuperAdmin()
    // {
    //     return $this->hasRole('super_admin');
    // }

    /**
     * Get the admin's roles as an array.
     */
    public function getRolesArray()
    {
        return is_array($this->roles) ? $this->roles : [];
    }

    /**
     * Check if the admin has a specific role/permission.
     */
    public function hasRole($role)
    {
        if (is_array($this->roles) && in_array('full_access', $this->roles)) {
            return true;
        }
        return in_array($role, $this->getRolesArray());
    }

    /**
     * Check if the admin has a specific permission.
     */
    public function hasPermission($permission)
    {
        return $this->hasRole($permission);
    }
}
