<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cart extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'product_id',
        'quantity',
        'dynamic_selections',
        'additional_price',
        'total_price'
    ];

    protected $casts = [
        'dynamic_selections' => 'array',
        'additional_price' => 'decimal:2',
        'total_price' => 'decimal:2'
    ];

    // Custom accessor for dynamic_selections to handle both string and array
    public function getDynamicSelectionsAttribute($value)
    {
        if (is_string($value)) {
            $decoded = json_decode($value, true);
            return is_array($decoded) ? $decoded : [];
        }
        return $value ?? [];
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
