<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChatMessage extends Model
{
    use HasFactory;

    protected $fillable = ['chat_room_id', 'sender_type', 'sender_id', 'message', 'is_read', 'delivery_status'];

    public function chatRoom() {
        return $this->belongsTo(ChatRoom::class);
    }

    public function user() {
        return $this->belongsTo(User::class, 'sender_id');
    }

    public function admin() {
        return $this->belongsTo(Admin::class, 'sender_id');
    }

    public function getSenderNameAttribute() {
        if ($this->sender_type === 'admin') {
            return $this->admin ? $this->admin->name : 'Support';
        } else {
            return $this->user ? $this->user->name : 'User';
        }
    }

    // Mark message as delivered
    public function markAsDelivered() {
        $this->update(['delivery_status' => 'delivered']);
    }

    // Mark message as read
    public function markAsRead() {
        $this->update([
            'is_read' => true,
            'delivery_status' => 'read'
        ]);
    }

    // Get delivery status icon
    public function getDeliveryStatusIcon() {
        switch ($this->delivery_status) {
            case 'sent':
                return '✓';
            case 'delivered':
                return '✓✓';
            case 'read':
                return '✓✓';
            default:
                return '';
        }
    }

    // Get delivery status color class
    public function getDeliveryStatusColor() {
        switch ($this->delivery_status) {
            case 'sent':
                return 'text-gray-400';
            case 'delivered':
                return 'text-blue-500';
            case 'read':
                return 'text-green-500';
            default:
                return 'text-gray-400';
        }
    }
}
