<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChatRoom extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'admin_id', 'is_active'];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function admin() {
        return $this->belongsTo(Admin::class);
    }

    public function messages() {
        return $this->hasMany(ChatMessage::class);
    }

    public function getUnreadCountAttribute()
    {
        return $this->messages()->where('sender_type', 'user')->where('is_read', false)->count();
    }
}
