<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CooperationRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'type', 'name', 'email', 'mobile', 'whatsapp',
        'store_name', 'store_phone', 'store_address', 'website', 'brands', 'product_types', 'registration_number', 'years_in_business',
        'company_name', 'company_address', 'products_needed', 'quantity', 'preferred_brands', 'delivery_address', 'budget', 'purchase_frequency',
        'ads_type', 'platforms', 'audience', 'experience', 'proposal',
        'description', 'status'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
