<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'slug',
        'content',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'og_title',
        'og_description',
        'og_image',
        'twitter_title',
        'twitter_description',
        'twitter_image',
        'canonical_url',
        'robots_directive',
        'seo_priority',
        'seo_indexable',
        'show_in_sitemap',
        'show_in_menu',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'seo_indexable' => 'boolean',
        'show_in_sitemap' => 'boolean',
        'show_in_menu' => 'boolean',
    ];
}
