<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Storage;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind('files', function () {
            return new Filesystem;
        });
    }

    public function boot()
    {
        // شمارش مجموع پیام‌های خوانده‌نشده همه چت‌ها برای سایدبار
        $global_unread_count = 0;
        $chatFiles = Storage::disk('local')->files('private/chats');
        foreach ($chatFiles as $file) {
            $messages = json_decode(Storage::disk('local')->get($file), true);
            $global_unread_count += collect($messages)->where('sender_type', 'user')->whereIn('is_read', [false, 0, '0', 'false'])->count();
        }
        View::share('global_unread_count', $global_unread_count);
    }
}
