<?php

namespace App\Services;

use App\Models\ChatMessage;
use Illuminate\Support\Facades\Storage;

class ChatFileService
{
    public function getNextId($chatRoomId)
    {
        $messages = $this->getMessages($chatRoomId);
        if (empty($messages)) return 1;
        return max(array_column($messages, 'id')) + 1;
    }

    public function updateMessage($chatRoomId, $messageId, $data)
    {
        $messages = $this->getMessages($chatRoomId);
        foreach ($messages as &$msg) {
            if ($msg['id'] == $messageId) {
                $msg = array_merge($msg, $data);
            }
        }
        unset($msg);
        $this->updateMessages($chatRoomId, $messages);
    }

    public function getMessages($chatRoomId)
    {
        $path = $this->getFilePath($chatRoomId);
        if (!Storage::disk('local')->exists($path)) {
            return [];
        }
        $content = Storage::disk('local')->get($path);
        $messages = json_decode($content, true);
        return is_array($messages) ? $messages : [];
    }

    public function updateMessages($chatRoomId, $messages)
    {
        Storage::disk('local')->put($this->getFilePath($chatRoomId), json_encode($messages));
    }

    protected function getFilePath($chatRoomId)
    {
        // اگر فایل در private/chats وجود داشت، همان را برگردان
        $privatePath = "private/chats/{$chatRoomId}.json";
        if (\Storage::disk('local')->exists($privatePath)) {
            return $privatePath;
        }
        // مسیر پیش‌فرض
        return "chats/{$chatRoomId}.json";
    }
}
