<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // First drop the old foreign key if it exists
            if (Schema::hasColumn('products', 'user_id')) {
                $table->dropForeign(['user_id']);
                $table->dropColumn('user_id');
            }

            // Add the new admin_id column
            if (!Schema::hasColumn('products', 'admin_id')) {
                $table->foreignId('admin_id')->after('id')->constrained('admins')->onDelete('cascade');
            }
        });
    }

    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // Drop the admin_id foreign key and column
            $table->dropForeign(['admin_id']);
            $table->dropColumn('admin_id');

            // Add back the user_id column
            $table->foreignId('user_id')->after('id')->constrained('users')->onDelete('cascade');
        });
    }
};
