<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // 1. Fix products table
        Schema::table('products', function (Blueprint $table) {
            // Drop old foreign key if exists
            // if (Schema::hasColumn('products', 'user_id')) {
            //     $table->dropForeign(['user_id']);
            //     $table->renameColumn('user_id', 'admin_id');
            // }

            // Add new columns if they don't exist
            if (!Schema::hasColumn('products', 'slug')) {
                $table->string('slug')->unique()->after('name');
            }
            if (!Schema::hasColumn('products', 'is_featured')) {
                $table->boolean('is_featured')->default(false)->after('is_approved');
            }
        });

        // Add foreign key to admins table
        Schema::table('products', function (Blueprint $table) {
            if (!Schema::hasColumn('products', 'admin_id')) {
                $table->foreignId('admin_id')->after('id')->constrained('admins')->onDelete('cascade');
            }
        });

        // 2. Create product_images table if it doesn't exist
        if (!Schema::hasTable('product_images')) {
            Schema::create('product_images', function (Blueprint $table) {
                $table->id();
                $table->foreignId('product_id')->constrained()->onDelete('cascade');
                $table->string('path');
                $table->integer('order')->default(0);
                $table->timestamps();
            });
        }

        // 3. Fix orders table
        Schema::table('orders', function (Blueprint $table) {
            // Add country and city columns if they don't exist
            if (!Schema::hasColumn('orders', 'country')) {
                $table->string('country')->nullable()->after('address');
            }
            if (!Schema::hasColumn('orders', 'city')) {
                $table->string('city')->nullable()->after('country');
            }
        });
    }

    public function down(): void
    {
        // Drop product_images table
        Schema::dropIfExists('product_images');

        // Revert products table changes
        Schema::table('products', function (Blueprint $table) {
            $table->dropForeign(['admin_id']);
            $table->renameColumn('admin_id', 'user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->dropColumn(['slug', 'is_featured']);
        });

        // Revert orders table changes
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn(['country', 'city']);
        });
    }
};
