<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('cooperation_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('type'); // seller, buyer, advertiser
            $table->string('name');
            $table->string('email')->nullable();
            $table->string('mobile');
            $table->string('whatsapp')->nullable();
            // Seller fields
            $table->string('store_name')->nullable();
            $table->string('store_phone')->nullable();
            $table->string('store_address')->nullable();
            $table->string('website')->nullable();
            $table->string('brands')->nullable();
            $table->string('product_types')->nullable();
            $table->string('registration_number')->nullable();
            $table->integer('years_in_business')->nullable();
            // Buyer fields
            $table->string('company_name')->nullable();
            $table->string('company_address')->nullable();
            $table->string('products_needed')->nullable();
            $table->integer('quantity')->nullable();
            $table->string('preferred_brands')->nullable();
            $table->string('delivery_address')->nullable();
            $table->string('budget')->nullable();
            $table->string('purchase_frequency')->nullable();
            // Advertiser fields
            $table->string('ads_type')->nullable();
            $table->string('platforms')->nullable();
            $table->string('audience')->nullable();
            $table->text('experience')->nullable();
            $table->text('proposal')->nullable();
            // Common
            $table->text('description')->nullable();
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('cooperation_requests');
    }
};
