<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // SEO Meta Fields
            $table->string('meta_title')->nullable()->after('description');
            $table->text('meta_description')->nullable()->after('meta_title');
            $table->text('meta_keywords')->nullable()->after('meta_description');

            // Open Graph Fields
            $table->string('og_title')->nullable()->after('meta_keywords');
            $table->text('og_description')->nullable()->after('og_title');
            $table->string('og_image')->nullable()->after('og_description');

            // Twitter Card Fields
            $table->string('twitter_title')->nullable()->after('og_image');
            $table->text('twitter_description')->nullable()->after('twitter_title');
            $table->string('twitter_image')->nullable()->after('twitter_description');

            // Schema.org Structured Data
            $table->json('schema_markup')->nullable()->after('twitter_image');

            // SEO URL and Canonical
            $table->string('seo_url')->nullable()->after('schema_markup');
            $table->string('canonical_url')->nullable()->after('seo_url');

            // SEO Status
            $table->boolean('seo_indexable')->default(true)->after('canonical_url');
            $table->string('seo_priority')->default('normal')->after('seo_indexable'); // low, normal, high

            // Image Alt Text (for automatic generation)
            $table->json('image_alt_texts')->nullable()->after('seo_priority');

            // Additional SEO Fields
            $table->string('brand')->nullable()->after('image_alt_texts');
            $table->string('model')->nullable()->after('brand');
            $table->string('sku')->nullable()->after('model');
            $table->string('gtin')->nullable()->after('sku'); // Global Trade Item Number
            $table->string('mpn')->nullable()->after('gtin'); // Manufacturer Part Number

            // Rich Snippets
            $table->decimal('rating_value', 3, 2)->nullable()->after('mpn');
            $table->integer('rating_count')->default(0)->after('rating_value');
            $table->decimal('price_range_min', 10, 2)->nullable()->after('rating_count');
            $table->decimal('price_range_max', 10, 2)->nullable()->after('price_range_min');

            // Local SEO
            $table->string('availability')->default('in_stock')->after('price_range_max'); // in_stock, out_of_stock, preorder
            $table->string('condition')->default('new')->after('availability'); // new, used, refurbished
        });
    }

    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'meta_title', 'meta_description', 'meta_keywords',
                'og_title', 'og_description', 'og_image',
                'twitter_title', 'twitter_description', 'twitter_image',
                'schema_markup', 'seo_url', 'canonical_url',
                'seo_indexable', 'seo_priority', 'image_alt_texts',
                'brand', 'model', 'sku', 'gtin', 'mpn',
                'rating_value', 'rating_count', 'price_range_min', 'price_range_max',
                'availability', 'condition'
            ]);
        });
    }
};
