<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            // SEO Meta Fields
            $table->string('meta_title')->nullable()->after('description');
            $table->text('meta_description')->nullable()->after('meta_title');
            $table->text('meta_keywords')->nullable()->after('meta_description');

            // Open Graph Fields
            $table->string('og_title')->nullable()->after('meta_keywords');
            $table->text('og_description')->nullable()->after('og_title');
            $table->string('og_image')->nullable()->after('og_description');

            // Twitter Card Fields
            $table->string('twitter_title')->nullable()->after('og_image');
            $table->text('twitter_description')->nullable()->after('twitter_title');
            $table->string('twitter_image')->nullable()->after('twitter_description');

            // Schema.org Structured Data
            $table->json('schema_markup')->nullable()->after('twitter_image');

            // SEO URL and Canonical
            $table->string('seo_url')->nullable()->after('schema_markup');
            $table->string('canonical_url')->nullable()->after('seo_url');

            // SEO Status
            $table->boolean('seo_indexable')->default(true)->after('canonical_url');
            $table->string('seo_priority')->default('normal')->after('seo_indexable');

            // Category SEO
            $table->string('category_type')->default('product')->after('seo_priority'); // product, service, blog
            $table->integer('sort_order')->default(0)->after('category_type');
            $table->boolean('show_in_menu')->default(true)->after('sort_order');
            $table->boolean('show_in_sitemap')->default(true)->after('show_in_menu');

            // Rich Snippets
            $table->integer('product_count')->default(0)->after('show_in_sitemap');
            $table->decimal('avg_price', 10, 2)->nullable()->after('product_count');
        });
    }

    public function down(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropColumn([
                'meta_title', 'meta_description', 'meta_keywords',
                'og_title', 'og_description', 'og_image',
                'twitter_title', 'twitter_description', 'twitter_image',
                'schema_markup', 'seo_url', 'canonical_url',
                'seo_indexable', 'seo_priority', 'category_type',
                'sort_order', 'show_in_menu', 'show_in_sitemap',
                'product_count', 'avg_price'
            ]);
        });
    }
};
