<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('order_items', function (Blueprint $table) {
            $table->json('dynamic_selections')->nullable()->after('quantity');
            $table->decimal('additional_price', 10, 2)->nullable()->default(0.00)->after('dynamic_selections');
            $table->decimal('total_price', 10, 2)->nullable()->after('additional_price');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_items', function (Blueprint $table) {
            $table->dropColumn(['dynamic_selections', 'additional_price', 'total_price']);
        });
    }
};
