<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('pages', function (Blueprint $table) {
            // Basic SEO Fields
            $table->string('meta_title')->nullable()->after('content');
            $table->text('meta_description')->nullable()->after('meta_title');
            $table->text('meta_keywords')->nullable()->after('meta_description');

            // Open Graph Fields
            $table->string('og_title')->nullable()->after('meta_keywords');
            $table->text('og_description')->nullable()->after('og_title');
            $table->string('og_image')->nullable()->after('og_description');
            $table->string('og_type')->default('website')->after('og_image');

            // Twitter Card Fields
            $table->string('twitter_title')->nullable()->after('og_type');
            $table->text('twitter_description')->nullable()->after('twitter_title');
            $table->string('twitter_image')->nullable()->after('twitter_description');
            $table->string('twitter_card')->default('summary_large_image')->after('twitter_image');

            // Advanced SEO Fields
            $table->string('canonical_url')->nullable()->after('twitter_card');
            $table->json('schema_markup')->nullable()->after('canonical_url');
            $table->string('seo_priority')->default('normal')->after('schema_markup');
            $table->boolean('seo_indexable')->default(true)->after('seo_priority');
            $table->string('robots_directive')->default('index,follow')->after('seo_indexable');

            // Page-specific SEO
            $table->string('page_type')->default('page')->after('robots_directive');
            $table->integer('sort_order')->default(0)->after('page_type');
            $table->boolean('show_in_sitemap')->default(true)->after('sort_order');
            $table->boolean('show_in_menu')->default(false)->after('show_in_sitemap');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pages', function (Blueprint $table) {
            $table->dropColumn([
                'meta_title',
                'meta_description',
                'meta_keywords',
                'og_title',
                'og_description',
                'og_image',
                'og_type',
                'twitter_title',
                'twitter_description',
                'twitter_image',
                'twitter_card',
                'canonical_url',
                'schema_markup',
                'seo_priority',
                'seo_indexable',
                'robots_directive',
                'page_type',
                'sort_order',
                'show_in_sitemap',
                'show_in_menu'
            ]);
        });
    }
};
