<?php

namespace Database\Seeders;

use App\Models\Admin;
use App\Models\Role;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;

class AdminSeeder extends Seeder
{
    public function run(): void
    {
        try {
            // First, delete any existing admin
            Admin::where('email', 'admin@site.com')->delete();

            // Get super admin role
            $superAdminRole = Role::where('name', 'super_admin')->first();

            if (!$superAdminRole) {
                Log::error('Super admin role not found');
                return;
            }

            // Create new admin with fresh password hash
            $password = 'admin123';
            $hashedPassword = Hash::make($password);

            Log::info('Creating admin with password', [
                'plain_password' => $password,
                'hashed_password' => $hashedPassword
            ]);

            $admin = Admin::create([
                'name' => 'Admin',
                'email' => 'admin@site.com',
                'password' => $hashedPassword,
                'role_id' => $superAdminRole->id,
            ]);

            Log::info('Admin created successfully', [
                'id' => $admin->id,
                'email' => $admin->email,
                'password_hash' => $admin->password,
                'role_id' => $admin->role_id
            ]);
        } catch (\Exception $e) {
            Log::error('Error creating admin', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
        }
    }
}
