<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use Illuminate\Support\Str;

class CategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Electronics',
                'description' => 'Latest electronic devices and gadgets',
                'meta_title' => 'Electronics - Premium Electronic Devices | Royalux',
                'meta_description' => 'Discover premium electronic devices and gadgets. Shop the latest smartphones, laptops, and tech accessories with secure checkout.',
                'meta_keywords' => 'electronics, smartphones, laptops, gadgets, tech, devices, mobile, computer',
            ],
            [
                'name' => 'Fashion',
                'description' => 'Trendy fashion items and accessories',
                'meta_title' => 'Fashion - Designer Clothing & Accessories | Royalux',
                'meta_description' => 'Explore designer fashion items and accessories. Shop trendy clothing, bags, and fashion accessories with premium quality.',
                'meta_keywords' => 'fashion, clothing, designer, accessories, bags, shoes, luxury fashion',
            ],
            [
                'name' => 'Home & Garden',
                'description' => 'Home decoration and garden supplies',
                'meta_title' => 'Home & Garden - Premium Home Decor | Royalux',
                'meta_description' => 'Transform your home with premium decoration items and garden supplies. Quality home decor for every room.',
                'meta_keywords' => 'home decor, garden, furniture, decoration, interior design, outdoor',
            ],
            [
                'name' => 'Sports & Outdoors',
                'description' => 'Sports equipment and outdoor gear',
                'meta_title' => 'Sports & Outdoors - Premium Sports Equipment | Royalux',
                'meta_description' => 'Get premium sports equipment and outdoor gear. Quality products for fitness, sports, and outdoor activities.',
                'meta_keywords' => 'sports, fitness, outdoor, equipment, gear, exercise, training',
            ],
            [
                'name' => 'Books & Media',
                'description' => 'Books, movies, and media content',
                'meta_title' => 'Books & Media - Premium Books & Entertainment | Royalux',
                'meta_description' => 'Discover premium books, movies, and media content. Quality entertainment for every taste and interest.',
                'meta_keywords' => 'books, movies, media, entertainment, literature, films, music',
            ],
        ];

        foreach ($categories as $categoryData) {
            $category = Category::where('name', $categoryData['name'])->first();

            if ($category) {
                // Update existing category with SEO data
                $category->update([
                    'meta_title' => $categoryData['meta_title'],
                    'meta_description' => $categoryData['meta_description'],
                    'meta_keywords' => $categoryData['meta_keywords'],
                ]);
            } else {
                // Create new category with SEO data
                Category::create($categoryData);
            }
        }
    }
}
