<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            RoleSeeder::class,
            PermissionSeeder::class,
            ProductSeeder::class,
            AdminSeeder::class,
        ]);

        // Enable all payment gateways
        Setting::setValue('enabled_gateways', [
            'paypal',
            'stripe',
            'nowpayments',
            'bitpay',
            'coingate',
            'payoneer',
            'wise'
        ], 'json');
    }
}
