<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;

class PermissionSeeder extends Seeder
{
    public function run(): void
    {
        $permissions = [
            // Dashboard
            ['name' => 'view_dashboard', 'guard_name' => 'admin'],

            // Products
            ['name' => 'view_products', 'guard_name' => 'admin'],
            ['name' => 'create_products', 'guard_name' => 'admin'],
            ['name' => 'edit_products', 'guard_name' => 'admin'],
            ['name' => 'delete_products', 'guard_name' => 'admin'],

            // Categories
            ['name' => 'view_categories', 'guard_name' => 'admin'],
            ['name' => 'create_categories', 'guard_name' => 'admin'],
            ['name' => 'edit_categories', 'guard_name' => 'admin'],
            ['name' => 'delete_categories', 'guard_name' => 'admin'],

            // Orders
            ['name' => 'view_orders', 'guard_name' => 'admin'],
            ['name' => 'edit_orders', 'guard_name' => 'admin'],
            ['name' => 'delete_orders', 'guard_name' => 'admin'],
            ['name' => 'approve_orders', 'guard_name' => 'admin'],
            ['name' => 'ship_orders', 'guard_name' => 'admin'],

            // Users
            ['name' => 'view_users', 'guard_name' => 'admin'],
            ['name' => 'edit_users', 'guard_name' => 'admin'],
            ['name' => 'delete_users', 'guard_name' => 'admin'],

            // Reviews
            ['name' => 'view_reviews', 'guard_name' => 'admin'],
            ['name' => 'approve_reviews', 'guard_name' => 'admin'],
            ['name' => 'reject_reviews', 'guard_name' => 'admin'],
            ['name' => 'delete_reviews', 'guard_name' => 'admin'],

            // Pages
            ['name' => 'view_pages', 'guard_name' => 'admin'],
            ['name' => 'create_pages', 'guard_name' => 'admin'],
            ['name' => 'edit_pages', 'guard_name' => 'admin'],
            ['name' => 'delete_pages', 'guard_name' => 'admin'],

            // Contact Messages
            ['name' => 'view_contacts', 'guard_name' => 'admin'],
            ['name' => 'delete_contacts', 'guard_name' => 'admin'],
            ['name' => 'mark_contacts_read', 'guard_name' => 'admin'],

            // Chat Support
            ['name' => 'view_chats', 'guard_name' => 'admin'],
            ['name' => 'send_chat_messages', 'guard_name' => 'admin'],
            ['name' => 'close_chats', 'guard_name' => 'admin'],

            // Settings
            ['name' => 'view_settings', 'guard_name' => 'admin'],
            ['name' => 'edit_settings', 'guard_name' => 'admin'],

            // Admin Management
            ['name' => 'view_admins', 'guard_name' => 'admin'],
            ['name' => 'create_admins', 'guard_name' => 'admin'],
            ['name' => 'edit_admins', 'guard_name' => 'admin'],
            ['name' => 'delete_admins', 'guard_name' => 'admin'],

            // Roles & Permissions
            ['name' => 'view_roles', 'guard_name' => 'admin'],
            ['name' => 'create_roles', 'guard_name' => 'admin'],
            ['name' => 'edit_roles', 'guard_name' => 'admin'],
            ['name' => 'delete_roles', 'guard_name' => 'admin'],
            ['name' => 'assign_permissions', 'guard_name' => 'admin'],
        ];

        foreach ($permissions as $permission) {
            Permission::create($permission);
        }
    }
}
