<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\User;
use App\Models\Category;
use Illuminate\Support\Facades\Hash;

class ProductSeeder extends Seeder
{
    public function run(): void
    {
        // Create categories
        $categories = [
            'Laptop' => Category::create(['name' => 'Laptop', 'slug' => 'laptop']),
            'Mobile' => Category::create(['name' => 'Mobile', 'slug' => 'mobile']),
            'Headphone' => Category::create(['name' => 'Headphone', 'slug' => 'headphone']),
            'Camera' => Category::create(['name' => 'Camera', 'slug' => 'camera']),
            'Gaming' => Category::create(['name' => 'Gaming', 'slug' => 'gaming']),
        ];

        // Create a seller user
        $seller = User::create([
            'name' => 'Seller',
            'email' => 'seller@example.com',
            'password' => bcrypt('password'),
        ]);

        // Create products
        $products = [
            [
                'name' => 'Apple MacBook Pro',
                'description' => 'Apple MacBook Pro with M2 processor, 16GB RAM, and 512GB SSD. 14-inch Liquid Retina XDR display with Wi-Fi 6E support and Thunderbolt 4 and MagSafe 3 ports.',
                'price' => 85000000,
                'stock' => 10,
                'image' => 'products/macbook.jpg',
                'category_id' => $categories['Laptop']->id,
                'user_id' => $seller->id,
                'is_approved' => true
            ],
            [
                'name' => 'Samsung Galaxy S24',
                'description' => 'Samsung Galaxy S24 with 200MP camera, Snapdragon 8 Gen 3 processor, and 6.8-inch Dynamic AMOLED 2X display with 120Hz refresh rate. 5000mAh battery with 45W fast charging support.',
                'price' => 45000000,
                'stock' => 15,
                'image' => 'products/s24.jpg',
                'category_id' => $categories['Mobile']->id,
                'user_id' => $seller->id,
                'is_approved' => true
            ],
            [
                'name' => 'Sony WH-1000XM5',
                'description' => 'Sony WH-1000XM5 with advanced noise cancellation and 8 microphones. 30-hour battery life with Bluetooth 5.2 support and Hi-Res Audio quality.',
                'price' => 12000000,
                'stock' => 20,
                'image' => 'products/sony.jpg',
                'category_id' => $categories['Headphone']->id,
                'user_id' => $seller->id,
                'is_approved' => true
            ],
            [
                'name' => 'Canon EOS R6',
                'description' => 'Canon EOS R6 with 4K video capability and 20MP sensor. 5-axis image stabilization and dual memory card support. Water and dust resistant.',
                'price' => 65000000,
                'stock' => 8,
                'image' => 'products/canon.jpg',
                'category_id' => $categories['Camera']->id,
                'user_id' => $seller->id,
                'is_approved' => true
            ],
            [
                'name' => 'PlayStation 5',
                'description' => 'PlayStation 5 with AMD Zen 2 processor and RDNA 2 graphics. High-speed SSD storage with 4K and 120fps support. DualSense controller with haptic feedback.',
                'price' => 25000000,
                'stock' => 12,
                'image' => 'products/ps5.jpg',
                'category_id' => $categories['Gaming']->id,
                'user_id' => $seller->id,
                'is_approved' => true
            ]
        ];

        foreach ($products as $product) {
            Product::create($product);
        }
    }
}
