<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\Permission;
use Illuminate\Database\Seeder;

class RolePermissionSeeder extends Seeder
{
    public function run(): void
    {
        // Super Admin - All permissions
        $superAdmin = Role::where('name', 'super_admin')->first();
        $allPermissions = Permission::all();
        $superAdmin->permissions()->attach($allPermissions->pluck('id'));

        // Admin - Most permissions except admin management
        $admin = Role::where('name', 'admin')->first();
        $adminPermissions = Permission::whereNotIn('module', ['admins', 'roles'])->get();
        $admin->permissions()->attach($adminPermissions->pluck('id'));

        // Product Manager
        $productManager = Role::where('name', 'product_manager')->first();
        $productPermissions = Permission::whereIn('module', ['products', 'categories', 'reviews'])->get();
        $productManager->permissions()->attach($productPermissions->pluck('id'));

        // Order Manager
        $orderManager = Role::where('name', 'order_manager')->first();
        $orderPermissions = Permission::whereIn('module', ['orders', 'users', 'chats'])->get();
        $orderManager->permissions()->attach($orderPermissions->pluck('id'));

        // Content Manager
        $contentManager = Role::where('name', 'content_manager')->first();
        $contentPermissions = Permission::whereIn('module', ['pages', 'contacts'])->get();
        $contentManager->permissions()->attach($contentPermissions->pluck('id'));

        // Support Agent
        $supportAgent = Role::where('name', 'support_agent')->first();
        $supportPermissions = Permission::whereIn('module', ['chats', 'contacts'])->get();
        $supportAgent->permissions()->attach($supportPermissions->pluck('id'));
    }
}
