<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    public function run(): void
    {
        $roles = [
            [
                'name' => 'super_admin',
                'guard_name' => 'admin',
            ],
            [
                'name' => 'admin',
                'guard_name' => 'admin',
            ],
            [
                'name' => 'product_manager',
                'guard_name' => 'admin',
            ],
            [
                'name' => 'order_manager',
                'guard_name' => 'admin',
            ],
            [
                'name' => 'content_manager',
                'guard_name' => 'admin',
            ],
            [
                'name' => 'support_agent',
                'guard_name' => 'admin',
            ],
        ];

        foreach ($roles as $role) {
            Role::create($role);
        }
    }
}
