console.log('✅ admin global.js loaded');

if (document.getElementById('sidebar-toggle')) {
    document.getElementById('sidebar-toggle').addEventListener('click', function() {
        document.getElementById('sidebar').classList.toggle('-translate-x-full');
    });
}

// اعلان پیام جدید برای ادمین
function showAdminChatAlert(count) {
    //console.log('🔔 تعداد پیام جدید برای ادمین:', count);
    document.querySelectorAll('.admin-chat-alert-badge').forEach(function(badge) {
        badge.innerText = count > 99 ? '99+' : count;
        badge.style.display = count > 0 ? 'flex' : 'none';
    });
}

setInterval(function() {
    //console.log('⏰ ارسال درخواست AJAX برای پیام‌های خوانده‌نشده');
    fetch('/admin/chat/unread-messages')
        .then(res => res.json())
        .then(data => {
            if (data.success && data.unread_count > 0) {
                showAdminChatAlert(data.unread_count);
            } else {
                showAdminChatAlert(0);
            }
        });
}, 2000);

// Dark mode toggle function
function toggleDarkMode() {
    const html = document.documentElement;
    const isDark = html.classList.contains('dark');

    if (isDark) {
        html.classList.remove('dark');
        localStorage.setItem('theme', 'light');
    } else {
        html.classList.add('dark');
        localStorage.setItem('theme', 'dark');
    }
}

// Initialize theme from localStorage
function initTheme() {
    const savedTheme = localStorage.getItem('theme');
    const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

    if (savedTheme === 'dark' || (!savedTheme && prefersDark)) {
        document.documentElement.classList.add('dark');
    } else {
        document.documentElement.classList.remove('dark');
    }
}

// Call on page load
initTheme();

// Sidebar Toggle
const sidebarToggle = document.getElementById('sidebar-toggle');
const sidebar = document.getElementById('sidebar');
const mobileOverlay = document.getElementById('mobile-overlay');

if (sidebarToggle) {
    sidebarToggle.addEventListener('click', () => {
        sidebar.classList.toggle('-translate-x-full');
        mobileOverlay.classList.toggle('active');
    });
}

if (mobileOverlay) {
    mobileOverlay.addEventListener('click', () => {
        sidebar.classList.add('-translate-x-full');
        mobileOverlay.classList.remove('active');
    });
}

// Orders Dropdown Toggle
document.addEventListener('DOMContentLoaded', function() {
    var ordersDropdown = document.getElementById('orders-dropdown');
    var ordersSubmenu = document.getElementById('orders-submenu');
    var ordersChevron = document.getElementById('orders-chevron');
    if (ordersDropdown && ordersSubmenu && ordersChevron) {
        ordersDropdown.addEventListener('click', function(e) {
            e.stopPropagation();
            var isOpen = !ordersSubmenu.classList.contains('hidden');
            if (isOpen) {
                ordersSubmenu.classList.add('hidden');
                ordersChevron.classList.remove('rotate-180');
                ordersSubmenu.style.zIndex = '';
            } else {
                ordersSubmenu.classList.remove('hidden');
                ordersChevron.classList.add('rotate-180');
                ordersSubmenu.style.zIndex = '1000';
            }
        });
        // بستن زیرمنو با کلیک بیرون
        document.addEventListener('click', function(e) {
            if (!ordersSubmenu.classList.contains('hidden')) {
                if (!ordersSubmenu.contains(e.target) && !ordersDropdown.contains(e.target)) {
                    ordersSubmenu.classList.add('hidden');
                    ordersChevron.classList.remove('rotate-180');
                    ordersSubmenu.style.zIndex = '';
                }
            }
        });
    }
});

// Auto-hide alerts after 5 seconds
setTimeout(() => {
    const alerts = document.querySelectorAll('.animate-fade-in');
    alerts.forEach(alert => {
        alert.style.transition = 'opacity 0.5s ease-out';
        alert.style.opacity = '0';
        setTimeout(() => alert.remove(), 500);
    });
}, 5000);

// Responsive handling
function handleResize() {
    if (window.innerWidth >= 1024) {
        sidebar.classList.remove('-translate-x-full');
        mobileOverlay.classList.remove('active');
    } else {
        sidebar.classList.add('-translate-x-full');
        mobileOverlay.classList.remove('active');
    }
}

window.addEventListener('resize', handleResize);
window.addEventListener('load', handleResize);

// Touch handling for mobile
let touchStartX = 0;
let touchEndX = 0;

document.addEventListener('touchstart', e => {
    touchStartX = e.changedTouches[0].screenX;
});

document.addEventListener('touchend', e => {
    touchEndX = e.changedTouches[0].screenX;
    handleSwipe();
});

function handleSwipe() {
    if (window.innerWidth >= 1024) return;

    const swipeDistance = touchEndX - touchStartX;
    const minSwipeDistance = 100;

    if (swipeDistance > minSwipeDistance && sidebar.classList.contains('-translate-x-full')) {
        // Swipe right to open sidebar
        sidebar.classList.remove('-translate-x-full');
        mobileOverlay.classList.add('active');
    } else if (swipeDistance < -minSwipeDistance && !sidebar.classList.contains('-translate-x-full')) {
        // Swipe left to close sidebar
        sidebar.classList.add('-translate-x-full');
        mobileOverlay.classList.remove('active');
    }
}
