document.addEventListener('DOMContentLoaded', function() {
    // Payment method selection
    document.querySelectorAll('input.payment-method-radio').forEach(function(radio) {
        radio.addEventListener('change', function() {
            // Remove active state from all options
            document.querySelectorAll('.payment-option').forEach(function(option) {
                option.classList.remove('border-blue-500', 'bg-blue-50');
                option.querySelector('.radio-circle').classList.remove('border-blue-500');
                option.querySelector('.radio-dot').classList.remove('opacity-100');
                option.querySelector('.selection-indicator').classList.remove('opacity-100');
            });

            // Add active state to selected option
            if (this.checked) {
                const selectedOption = this.closest('.payment-option');
                if (this.value === 'crypto') {
                    selectedOption.classList.add('border-yellow-500', 'bg-yellow-50');
                    selectedOption.querySelector('.radio-circle').classList.add('border-yellow-500');
                    selectedOption.querySelector('.radio-dot').classList.add('opacity-100');
                    selectedOption.querySelector('.selection-indicator').classList.add('opacity-100');
                    document.getElementById('crypto-gateway-selection').classList.remove('hidden');
                } else {
                    selectedOption.classList.add('border-blue-500', 'bg-blue-50');
                    selectedOption.querySelector('.radio-circle').classList.add('border-blue-500');
                    selectedOption.querySelector('.radio-dot').classList.add('opacity-100');
                    selectedOption.querySelector('.selection-indicator').classList.add('opacity-100');
                    if (document.getElementById('crypto-gateway-selection')) {
                        document.getElementById('crypto-gateway-selection').classList.add('hidden');
                    }
                }
            }

            const paymentMethodHidden = document.getElementById('payment_method_hidden');
            if (this.value === 'crypto') {
                const cryptoGateway = document.getElementById('crypto_gateway');
                if (cryptoGateway) {
                    paymentMethodHidden.value = cryptoGateway.value;
                }
            } else {
                paymentMethodHidden.value = this.value;
            }
            // نمایش مقدار انتخاب‌شده در کنسول
            console.log('Selected gateway:', paymentMethodHidden.value);
        });
    });

    // Trigger change event on the checked radio button on page load
    const checkedRadio = document.querySelector('input.payment-method-radio:checked');
    if (checkedRadio) {
        checkedRadio.dispatchEvent(new Event('change'));
    }

    // Handle crypto currency selection
    const cryptoCurrencySelect = document.getElementById('crypto_currency');
    if (cryptoCurrencySelect) {
        // Function to load available cryptocurrencies
        const loadAvailableCryptos = async() => {
            try {
                const response = await fetch(`/api/available-cryptos?amount=${document.getElementById('total_amount').value}`);
                const currencies = await response.json();

                cryptoCurrencySelect.innerHTML = currencies.map(currency =>
                    `<option value="${currency.toLowerCase()}">${currency}</option>`
                ).join('');
            } catch (error) {
                console.error('Error loading cryptocurrencies:', error);
            }
        };

        // Load cryptocurrencies when crypto payment is selected
        document.querySelector('input.payment-method-radio[value="crypto"]').addEventListener('change', function() {
            if (this.checked) {
                loadAvailableCryptos();
            }
        });
    }

    // Update hidden input when crypto gateway changes and crypto is selected
    const cryptoGatewaySelect = document.getElementById('crypto_gateway');
    if (cryptoGatewaySelect) {
        cryptoGatewaySelect.addEventListener('change', function() {
            const cryptoRadio = document.querySelector('input.payment-method-radio[value="crypto"]');
            const paymentMethodHidden = document.getElementById('payment_method_hidden');
            if (cryptoRadio && cryptoRadio.checked) {
                paymentMethodHidden.value = this.value;
                // نمایش مقدار انتخاب‌شده در کنسول
                console.log('Selected gateway:', paymentMethodHidden.value);
            }
        });
    }

    // On form submit, set hidden payment_method value
    const checkoutForm = document.getElementById('checkout-form');
    if (checkoutForm) {
        checkoutForm.addEventListener('submit', function(e) {
            const checkedRadio = document.querySelector('input.payment-method-radio:checked');
            const paymentMethodHidden = document.getElementById('payment_method_hidden');
            if (checkedRadio) {
                if (checkedRadio.value === 'crypto') {
                    const cryptoGateway = document.getElementById('crypto_gateway');
                    if (cryptoGateway) {
                        paymentMethodHidden.value = cryptoGateway.value;
                    }
                } else {
                    paymentMethodHidden.value = checkedRadio.value;
                }
            }
            // Debug: log the value being sent
            console.log('Submitting payment_method:', paymentMethodHidden.value);
        });
    }

    // Custom radio group logic for payment methods (since no name)
    document.querySelectorAll('.payment-option').forEach(function(option) {
        option.addEventListener('click', function(e) {
            // Prevent double event if clicking the radio directly
            if (e.target.tagName.toLowerCase() === 'input') return;
            // Uncheck all radios
            document.querySelectorAll('.payment-method-radio').forEach(function(radio) {
                radio.checked = false;
            });
            // Check the radio inside this label
            const radio = this.querySelector('.payment-method-radio');
            if (radio) {
                radio.checked = true;
                radio.dispatchEvent(new Event('change'));
            }
        });
    });
});