<x-admin-layout>
    <x-slot name="title">
        Edit Admin
    </x-slot>

    <div class="max-w-xl mx-auto bg-slate-100 p-4 rounded-md">
        <h1 class="text-2xl font-bold mb-6">Edit Admin</h1>
        <form action="{{ route('admin.admins.update', $admin) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="mb-4">
                <label class="block text-gray-700 font-bold mb-2">Name</label>
                <input type="text" name="name" class="w-full border rounded px-3 py-2" value="{{ old('name', $admin->name) }}" required>
                @error('name')<div class="text-red-600 text-sm mt-1">{{ $message }}</div>@enderror
            </div>
            <div class="mb-4">
                <label class="block text-gray-700 font-bold mb-2">Email</label>
                <input type="email" name="email" class="w-full border rounded px-3 py-2" value="{{ old('email', $admin->email) }}" required>
                @error('email')<div class="text-red-600 text-sm mt-1">{{ $message }}</div>@enderror
            </div>
            <div class="mb-4">
                <label class="block text-gray-700 font-bold mb-2">Password <span class="text-gray-400 text-xs">(Leave blank to keep current)</span></label>
                <input type="password" name="password" class="w-full border rounded px-3 py-2">
                @error('password')<div class="text-red-600 text-sm mt-1">{{ $message }}</div>@enderror
            </div>
            <div class="mb-4">
                <label class="block text-gray-700 font-bold mb-2">Confirm Password</label>
                <input type="password" name="password_confirmation" class="w-full border rounded px-3 py-2">
            </div>
            <div class="mb-4">
                <label class="block text-gray-700 font-bold mb-2">Permissions (Sidebar & Actions)</label>
                @php
                    $allPermissions = [
                        'dashboard' => [
                            'view' => 'View Dashboard',
                        ],
                        'products' => [
                            'view' => 'View Products',
                            'create' => 'Create Product',
                            'edit' => 'Edit Product',
                            'delete' => 'Delete Product',
                        ],
                        'orders' => [
                            'view' => 'View Orders',
                            'create' => 'Create Order',
                            'edit' => 'Edit Order',
                            'delete' => 'Delete Order',
                        ],
                        'users' => [
                            'view' => 'View Users',
                            'create' => 'Create User',
                            'edit' => 'Edit User',
                            'delete' => 'Delete User',
                        ],
                        'admins' => [
                            'view' => 'View Admins',
                            'create' => 'Create Admin',
                            'edit' => 'Edit Admin',
                            'delete' => 'Delete Admin',
                        ],
                        'categories' => [
                            'view' => 'View Categories',
                            'create' => 'Create Category',
                            'edit' => 'Edit Category',
                            'delete' => 'Delete Category',
                        ],
                        'pages' => [
                            'view' => 'View Pages',
                            'create' => 'Create Page',
                            'edit' => 'Edit Page',
                            'delete' => 'Delete Page',
                        ],
                        'contacts' => [
                            'view' => 'View Contact Messages',
                            'delete' => 'Delete Contact Message',
                        ],
                        'reviews' => [
                            'view' => 'View Reviews',
                            'approve' => 'Approve Review',
                            'delete' => 'Delete Review',
                        ],
                        'chats' => [
                            'view' => 'View Chat Support',
                            'reply' => 'Reply to Chat',
                            'close' => 'Close Chat',
                        ],
                        'settings' => [
                            'view' => 'View Settings',
                            'edit' => 'Edit Settings',
                        ],
                        'newsletter' => [
                            'view' => 'View Newsletter Subscribers',
                        ],
                    ];
                    $adminPermissions = is_array($admin->roles) ? $admin->roles : [];
                @endphp
                <div class="mb-4">
                    <label class="flex items-center space-x-2 mb-2">
                        <input type="checkbox" id="full-access-checkbox" name="roles[]" value="full_access" {{ in_array('full_access', $adminPermissions) ? 'checked' : '' }}>
                        <span class="font-bold text-green-700">Full Access (Super Admin)</span>
                    </label>
                </div>
                <div id="permissions-list" class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    @foreach($allPermissions as $section => $actions)
                        <div class="border rounded p-2">
                            <div class="font-bold mb-2">{{ ucfirst($section) }}</div>
                            @foreach($actions as $actionKey => $actionLabel)
                                @php $permKey = $section.'.'.$actionKey; @endphp
                                <label class="flex items-center space-x-2 mb-1">
                                    <input type="checkbox" name="roles[]" value="{{ $permKey }}" {{ in_array($permKey, $adminPermissions) ? 'checked' : '' }}>
                                    <span>{{ $actionLabel }}</span>
                                </label>
                            @endforeach
                        </div>
                    @endforeach
                    <div class="border rounded p-2">
                        <div class="font-bold mb-2 text-pink-700">Cooperation Requests</div>
                        <label class="flex items-center space-x-2 mb-1">
                            <input type="checkbox" name="roles[]" value="cooperation-requests.view" {{ in_array('cooperation-requests.view', $adminPermissions) ? 'checked' : '' }}>
                            <span>View Cooperation Requests</span>
                        </label>
                    </div>
                </div>
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        var fullAccess = document.getElementById('full-access-checkbox');
                        var permissionsList = document.getElementById('permissions-list');
                        function togglePermissions() {
                            if(fullAccess.checked) {
                                permissionsList.style.display = 'none';
                            } else {
                                permissionsList.style.display = '';
                            }
                        }
                        fullAccess.addEventListener('change', togglePermissions);
                        togglePermissions(); // Initial state
                    });
                </script>
            </div>
            <div class="flex justify-end">
                <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">Update Admin</button>
            </div>
        </form>
    </div>
</x-admin-layout>
