<x-admin-layout>
    <div class="max-w-7xl mx-auto py-8 bg-slate-600 p-4 rounded-md">
        <h1 class="text-2xl font-bold mb-6 text-white">Cooperation Requests</h1>
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            <div class="bg-white rounded-xl shadow p-4 flex flex-col items-center">
                <div class="text-2xl font-bold text-gray-800">{{ $requests->total() }}</div>
                <div class="text-xs text-gray-500 mt-1">Total</div>
            </div>
            <div class="bg-yellow-100 rounded-xl shadow p-4 flex flex-col items-center">
                <div class="text-2xl font-bold text-yellow-800">{{ \App\Models\CooperationRequest::where('status','pending')->count() }}</div>
                <div class="text-xs text-yellow-700 mt-1">Pending</div>
            </div>
            <div class="bg-green-100 rounded-xl shadow p-4 flex flex-col items-center">
                <div class="text-2xl font-bold text-green-800">{{ \App\Models\CooperationRequest::where('status','approved')->count() }}</div>
                <div class="text-xs text-green-700 mt-1">Approved</div>
            </div>
            <div class="bg-red-100 rounded-xl shadow p-4 flex flex-col items-center">
                <div class="text-2xl font-bold text-red-800">{{ \App\Models\CooperationRequest::where('status','rejected')->count() }}</div>
                <div class="text-xs text-red-700 mt-1">Rejected</div>
            </div>
        </div>
        <div class="overflow-x-auto bg-white rounded-xl shadow p-4">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">ID</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Email</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Mobile</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Created</th>
                        <th class="px-4 py-2"></th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-100">
                    @forelse($requests as $req)
                    <tr>
                        <td class="px-4 py-2 text-sm">{{ $req->id }}</td>
                        <td class="px-4 py-2 text-sm capitalize">{{ $req->type }}</td>
                        <td class="px-4 py-2 text-sm">{{ $req->name }}</td>
                        <td class="px-4 py-2 text-sm">{{ $req->email }}</td>
                        <td class="px-4 py-2 text-sm">{{ $req->mobile }}</td>
                        <td class="px-4 py-2 text-sm">
                            <span class="inline-block px-2 py-1 rounded text-xs font-bold
                                @if($req->status=='pending') bg-yellow-100 text-yellow-800
                                @elseif($req->status=='approved') bg-green-100 text-green-800
                                @else bg-red-100 text-red-800 @endif">
                                {{ ucfirst($req->status) }}
                            </span>
                        </td>
                        <td class="px-4 py-2 text-sm">{{ $req->created_at->format('Y-m-d H:i') }}</td>
                        <td class="px-4 py-2 text-sm">
                            <a href="{{ route('admin.cooperation-requests.show', $req->id) }}" class="inline-block bg-gradient-to-r from-blue-500 to-purple-500 text-white px-4 py-1 rounded shadow hover:from-blue-600 hover:to-purple-600 transition">View</a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="px-4 py-6 text-center text-gray-400">No cooperation requests found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
            <div class="mt-4">{{ $requests->links() }}</div>
        </div>
    </div>
</x-admin-layout>
