<x-admin-layout>
    <div class="max-w-3xl mx-auto py-10 bg-slate-300 p-4 rounded-md">
        @if(session('success'))
            <div class="mb-6 bg-green-100 border-l-4 border-green-500 text-green-800 p-4 rounded-lg shadow">
                {{ session('success') }}
            </div>
        @endif
        <div class="flex items-center mb-8">
            <div class="flex-shrink-0 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full p-3">
                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/></svg>
            </div>
            <div class="ml-4">
                <h1 class="text-2xl font-extrabold text-gray-800">Cooperation Request #{{ $request->id }}</h1>
                <div class="mt-1 text-sm text-gray-500">Submitted at {{ $request->created_at->format('Y-m-d H:i') }}</div>
            </div>
            <div class="ml-auto">
                <span class="inline-block px-3 py-1 rounded-full text-xs font-bold
                    @if($request->status=='pending') bg-yellow-100 text-yellow-800
                    @elseif($request->status=='approved') bg-green-100 text-green-800
                    @else bg-red-100 text-red-800 @endif">
                    {{ ucfirst($request->status) }}
                </span>
            </div>
        </div>
        <div class="bg-white rounded-2xl shadow-xl p-8">
            <dl class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-4">
                <dt class="font-semibold text-gray-600">Type</dt>
                <dd class="text-gray-900 capitalize">{{ $request->type }}</dd>
                <dt class="font-semibold text-gray-600">Name</dt>
                <dd class="text-gray-900">{{ $request->name }}</dd>
                @if($request->email)
                <dt class="font-semibold text-gray-600">Email</dt>
                <dd class="text-gray-900">{{ $request->email }}</dd>
                @endif
                <dt class="font-semibold text-gray-600">Mobile</dt>
                <dd class="text-gray-900">{{ $request->mobile }}</dd>
                @if($request->whatsapp)
                <dt class="font-semibold text-gray-600">WhatsApp</dt>
                <dd class="text-gray-900">{{ $request->whatsapp }}</dd>
                @endif
                @if($request->store_name)
                <dt class="font-semibold text-gray-600">Store Name</dt>
                <dd class="text-gray-900">{{ $request->store_name }}</dd>
                @endif
                @if($request->store_phone)
                <dt class="font-semibold text-gray-600">Store Phone</dt>
                <dd class="text-gray-900">{{ $request->store_phone }}</dd>
                @endif
                @if($request->store_address)
                <dt class="font-semibold text-gray-600">Store Address</dt>
                <dd class="text-gray-900">{{ $request->store_address }}</dd>
                @endif
                @if($request->website)
                <dt class="font-semibold text-gray-600">Website/Social</dt>
                <dd class="text-gray-900">{{ $request->website }}</dd>
                @endif
                @if($request->brands)
                <dt class="font-semibold text-gray-600">Brands</dt>
                <dd class="text-gray-900">{{ $request->brands }}</dd>
                @endif
                @if($request->product_types)
                <dt class="font-semibold text-gray-600">Product Types</dt>
                <dd class="text-gray-900">{{ $request->product_types }}</dd>
                @endif
                @if($request->registration_number)
                <dt class="font-semibold text-gray-600">Business Registration</dt>
                <dd class="text-gray-900">{{ $request->registration_number }}</dd>
                @endif
                @if($request->years_in_business)
                <dt class="font-semibold text-gray-600">Years in Business</dt>
                <dd class="text-gray-900">{{ $request->years_in_business }}</dd>
                @endif
                @if($request->company_name)
                <dt class="font-semibold text-gray-600">Company Name</dt>
                <dd class="text-gray-900">{{ $request->company_name }}</dd>
                @endif
                @if($request->company_address)
                <dt class="font-semibold text-gray-600">Company Address</dt>
                <dd class="text-gray-900">{{ $request->company_address }}</dd>
                @endif
                @if($request->products_needed)
                <dt class="font-semibold text-gray-600">Products Needed</dt>
                <dd class="text-gray-900">{{ $request->products_needed }}</dd>
                @endif
                @if($request->quantity)
                <dt class="font-semibold text-gray-600">Quantity</dt>
                <dd class="text-gray-900">{{ $request->quantity }}</dd>
                @endif
                @if($request->preferred_brands)
                <dt class="font-semibold text-gray-600">Preferred Brands</dt>
                <dd class="text-gray-900">{{ $request->preferred_brands }}</dd>
                @endif
                @if($request->delivery_address)
                <dt class="font-semibold text-gray-600">Delivery Address</dt>
                <dd class="text-gray-900">{{ $request->delivery_address }}</dd>
                @endif
                @if($request->budget)
                <dt class="font-semibold text-gray-600">Budget</dt>
                <dd class="text-gray-900">{{ $request->budget }}</dd>
                @endif
                @if($request->purchase_frequency)
                <dt class="font-semibold text-gray-600">Purchase Frequency</dt>
                <dd class="text-gray-900">{{ $request->purchase_frequency }}</dd>
                @endif
                @if($request->ads_type)
                <dt class="font-semibold text-gray-600">Ads Type</dt>
                <dd class="text-gray-900">{{ $request->ads_type }}</dd>
                @endif
                @if($request->platforms)
                <dt class="font-semibold text-gray-600">Platforms</dt>
                <dd class="text-gray-900">{{ $request->platforms }}</dd>
                @endif
                @if($request->audience)
                <dt class="font-semibold text-gray-600">Audience</dt>
                <dd class="text-gray-900">{{ $request->audience }}</dd>
                @endif
                @if($request->experience)
                <dt class="font-semibold text-gray-600">Experience</dt>
                <dd class="text-gray-900">{{ $request->experience }}</dd>
                @endif
                @if($request->proposal)
                <dt class="font-semibold text-gray-600">Proposal</dt>
                <dd class="text-gray-900">{{ $request->proposal }}</dd>
                @endif
                @if($request->description)
                <dt class="font-semibold text-gray-600">Description</dt>
                <dd class="text-gray-900">{{ $request->description }}</dd>
                @endif
            </dl>
            <div class="mt-10 flex justify-between items-center">
                <a href="{{ route('admin.cooperation-requests.index') }}" class="inline-block bg-gradient-to-r from-blue-500 to-purple-500 text-white px-6 py-2 rounded-lg shadow hover:from-blue-600 hover:to-purple-600 transition">Back to List</a>
                @if($request->status === 'pending')
                <div class="flex gap-2">
                    <form method="POST" action="{{ route('admin.cooperation-requests.approve', $request->id) }}">
                        @csrf
                        @method('PUT')
                        <button type="submit" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded-lg shadow transition">Approve</button>
                    </form>
                    <form method="POST" action="{{ route('admin.cooperation-requests.reject', $request->id) }}">
                        @csrf
                        @method('PUT')
                        <button type="submit" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded-lg shadow transition">Reject</button>
                    </form>
                </div>
                @endif
            </div>
        </div>
    </div>
</x-admin-layout>
