
<x-admin-layout>
    <div class="min-h-screen bg-gradient-to-br from-gray-50 to-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-6 sm:py-8">
            <!-- Header -->
            <div class="mb-8">
                <h1 class="text-2xl sm:text-3xl lg:text-4xl font-bold text-gray-900 mb-2">Admin Dashboard</h1>
                <p class="text-gray-600 text-sm sm:text-base">Welcome back! Here's what's happening with your store today.</p>
            </div>

            <!-- Stats Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6 mb-8">
                <!-- Total Orders -->
                <div class="bg-white rounded-xl sm:rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 p-6 border border-gray-100 group">
                    <div class="flex items-center">
                        <div class="p-3 sm:p-4 rounded-full bg-gradient-to-r from-blue-100 to-blue-50 text-blue-600 group-hover:from-blue-200 group-hover:to-blue-100 transition-all duration-300">
                            <svg class="w-6 h-6 sm:w-7 sm:h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                            </svg>
                        </div>
                        <div class="ml-4 flex-1">
                            <h2 class="text-gray-500 text-xs sm:text-sm font-medium uppercase tracking-wide">Total Orders</h2>
                            <p class="text-2xl sm:text-3xl font-bold text-gray-900 mt-1">{{ $stats['total_orders'] }}</p>
                            <p class="text-xs text-green-600 font-medium mt-1">+12% from last month</p>
                        </div>
                    </div>
                </div>

                <!-- Total Products -->
                <div class="bg-white rounded-xl sm:rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 p-6 border border-gray-100 group">
                    <div class="flex items-center">
                        <div class="p-3 sm:p-4 rounded-full bg-gradient-to-r from-green-100 to-green-50 text-green-600 group-hover:from-green-200 group-hover:to-green-100 transition-all duration-300">
                            <svg class="w-6 h-6 sm:w-7 sm:h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                            </svg>
                        </div>
                        <div class="ml-4 flex-1">
                            <h2 class="text-gray-500 text-xs sm:text-sm font-medium uppercase tracking-wide">Total Products</h2>
                            <p class="text-2xl sm:text-3xl font-bold text-gray-900 mt-1">{{ $stats['total_products'] }}</p>
                            <p class="text-xs text-blue-600 font-medium mt-1">+5 new this week</p>
                        </div>
                    </div>
                </div>

                <!-- Total Users -->
                <div class="bg-white rounded-xl sm:rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 p-6 border border-gray-100 group">
                    <div class="flex items-center">
                        <div class="p-3 sm:p-4 rounded-full bg-gradient-to-r from-purple-100 to-purple-50 text-purple-600 group-hover:from-purple-200 group-hover:to-purple-100 transition-all duration-300">
                            <svg class="w-6 h-6 sm:w-7 sm:h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                        </div>
                        <div class="ml-4 flex-1">
                            <h2 class="text-gray-500 text-xs sm:text-sm font-medium uppercase tracking-wide">Total Users</h2>
                            <p class="text-2xl sm:text-3xl font-bold text-gray-900 mt-1">{{ $stats['total_users'] }}</p>
                            <p class="text-xs text-purple-600 font-medium mt-1">+8% growth rate</p>
                        </div>
                    </div>
                </div>

                <!-- Chat Support -->
                <div class="bg-white rounded-xl sm:rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 p-6 border border-gray-100 group">
                    <div class="flex items-center">
                        <div class="p-3 sm:p-4 rounded-full bg-gradient-to-r from-red-100 to-red-50 text-red-600 group-hover:from-red-200 group-hover:to-red-100 transition-all duration-300 relative">
                            <svg class="w-6 h-6 sm:w-7 sm:h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                            </svg>
                            <span id="admin-chat-unread-badge" class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center font-bold animate-pulse" style="display:none;">0</span>
                        </div>
                        <div class="ml-4 flex-1">
                            <h2 class="text-gray-500 text-xs sm:text-sm font-medium uppercase tracking-wide">Chat Support</h2>
                            <p class="text-2xl sm:text-3xl font-bold text-gray-900 mt-1">{{ $availableChats + $myUnreadChats }}</p>
                            <p class="text-xs text-gray-600 mt-1">{{ $availableChats }} available, {{ $myUnreadChats }} unread</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Chat Notifications Section -->
            @if($availableChats > 0 || $myUnreadChats > 0)
                <div class="bg-white rounded-xl sm:rounded-2xl shadow-lg mb-8 border border-gray-100 overflow-hidden">
                    <div class="px-6 py-4 bg-gradient-to-r from-red-50 via-orange-50 to-yellow-50 border-b border-gray-100">
                        <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4">
                            <h2 class="text-lg sm:text-xl font-bold text-red-800 flex items-center">
                                <svg class="w-5 h-5 mr-2 animate-bounce" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.864-.833-2.634 0L4.168 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                                </svg>
                                Chat Notifications
                            </h2>
                            <a href="{{ route('admin.chats') }}" class="inline-flex items-center bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg transition-all duration-300 text-sm font-semibold shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                </svg>
                                Manage Chats
                            </a>
                        </div>
                    </div>
                    <div class="p-6">
                        <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 sm:gap-6">
                            @if($availableChats > 0)
                                <div class="bg-gradient-to-r from-yellow-50 to-orange-50 border-2 border-yellow-200 rounded-xl p-6 hover:shadow-lg transition-all duration-300">
                                    <div class="flex items-center justify-between">
                                        <div class="flex-1">
                                            <h3 class="font-bold text-yellow-800 text-lg mb-1">Available Chats</h3>
                                            <p class="text-sm text-yellow-700">{{ $availableChats }} chats waiting for assignment</p>
                                            <p class="text-xs text-yellow-600 mt-2">Click "Manage Chats" to assign them</p>
                                        </div>
                                        <div class="ml-4">
                                            <span class="bg-gradient-to-r from-yellow-500 to-orange-500 text-white text-lg font-bold px-4 py-2 rounded-full shadow-lg animate-pulse">
                                                {{ $availableChats }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            @if($myUnreadChats > 0)
                                <div class="bg-gradient-to-r from-red-50 to-pink-50 border-2 border-red-200 rounded-xl p-6 hover:shadow-lg transition-all duration-300">
                                    <div class="flex items-center justify-between">
                                        <div class="flex-1">
                                            <h3 class="font-bold text-red-800 text-lg mb-1">Unread Messages</h3>
                                            <p class="text-sm text-red-700">{{ $totalUnreadMessages }} unread messages in your chats</p>
                                            <p class="text-xs text-red-600 mt-2">Respond quickly to maintain customer satisfaction</p>
                                        </div>
                                        <div class="ml-4">
                                            <span class="bg-gradient-to-r from-red-500 to-pink-500 text-white text-lg font-bold px-4 py-2 rounded-full shadow-lg animate-bounce">
                                                {{ $totalUnreadMessages }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @endif

            <!-- Recent Orders -->
            <div class="bg-white rounded-xl sm:rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 bg-gradient-to-r from-gray-50 to-blue-50 border-b border-gray-100">
                    <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4">
                        <h2 class="text-lg sm:text-xl font-bold text-gray-900 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                            </svg>
                            Recent Orders
                        </h2>
                        <a href="{{ route('admin.orders.index') }}" class="text-blue-600 hover:text-blue-800 font-medium text-sm transition-colors duration-300">
                            View All Orders →
                        </a>
                    </div>
                </div>
                <div class="overflow-hidden">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Order ID</th>
                                    <th class="px-4 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                                    <th class="px-4 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th class="px-4 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                                    <th class="px-4 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($stats['recent_orders'] as $order)
                                <tr class="hover:bg-gray-50 transition-colors duration-200">
                                    <td class="px-4 sm:px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-bold text-gray-900">#{{ $order->id }}</div>
                                    </td>
                                    <td class="px-4 sm:px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="w-8 h-8 rounded-full bg-gradient-to-r from-blue-400 to-purple-500 flex items-center justify-center text-white text-xs font-bold mr-3">
                                                {{ substr($order->user->name, 0, 1) }}
                                            </div>
                                            <div class="text-sm font-medium text-gray-900">{{ $order->user->name }}</div>
                                        </div>
                                    </td>
                                    <td class="px-4 sm:px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold
                                            @if($order->status === 'completed') bg-green-100 text-green-800 border border-green-200
                                            @elseif($order->status === 'pending') bg-yellow-100 text-yellow-800 border border-yellow-200
                                            @elseif($order->status === 'processing') bg-blue-100 text-blue-800 border border-blue-200
                                            @else bg-gray-100 text-gray-800 border border-gray-200
                                            @endif">
                                            @if($order->status === 'completed')
                                                <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                                </svg>
                                            @endif
                                            {{ ucfirst($order->status) }}
                                        </span>
                                    </td>
                                    <td class="px-4 sm:px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-bold text-gray-900">${{ number_format($order->total_amount, 2) }}</div>
                                    </td>
                                    <td class="px-4 sm:px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $order->created_at->format('M d, Y') }}
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Update unread message badge
    function updateAdminChatBadge(count) {
        let badge = document.getElementById('admin-chat-unread-badge');
        if (!badge) return;
        badge.innerText = count > 99 ? '99+' : count;
        badge.style.display = count > 0 ? 'flex' : 'none';
    }

    // Fetch unread messages count
    fetch('/admin/chat/unread-messages')
        .then(res => res.json())
        .then(data => {
            if (data.success && data.unread_count > 0) {
                updateAdminChatBadge(data.unread_count);
            } else {
                updateAdminChatBadge(0);
            }
        })
        .catch(error => {
            console.error('Error fetching unread messages:', error);
        });

    // Auto-refresh every 30 seconds
    setInterval(() => {
        fetch('/admin/chat/unread-messages')
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    updateAdminChatBadge(data.unread_count);
                }
            })
            .catch(error => {
                console.error('Error fetching unread messages:', error);
            });
    }, 30000);
});
</script>
@endpush
