<!DOCTYPE html>
@php
    $unreadContacts = \App\Models\Contact::where('is_read', false)->count();
    $pendingReviews = \App\Models\Review::where('is_approved', false)->count();
@endphp
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', '') }} - Admin Panel</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />

    <link rel="stylesheet" href="{{ asset('global/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('site/css/global.css') }}">
    <link rel="stylesheet" href="{{ asset('admin/css/style.css') }}">

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        body {
            font-family: 'Inter', sans-serif;
        }

        .sidebar-animate {
            transition: transform 0.3s ease-in-out, margin 0.3s ease-in-out;
        }

        .main-content-animate {
            transition: margin-left 0.3s ease-in-out;
        }

        .glass-effect {
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.95);
        }

        .dark .glass-effect {
            background: rgba(17, 24, 39, 0.95);
        }

        .gradient-bg {
            background: linear-gradient(135deg, #1f2937 0%, #111827 100%);
        }

        .dark .gradient-bg {
            background: linear-gradient(135deg, #0f172a 0%, #020617 100%);
        }

        .sidebar-item {
            position: relative;
            transition: all 0.3s ease;
        }

        .sidebar-item:hover {
            transform: translateX(5px);
        }

        .sidebar-item.active::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 4px;
            background: linear-gradient(180deg, #3b82f6, #8b5cf6);
            border-radius: 0 4px 4px 0;
        }

        .notification-badge {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }

        .mobile-overlay {
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.7);
            z-index: 40;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .mobile-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        @media (max-width: 1024px) {
            .sidebar-desktop {
                transform: translateX(-100%);
            }

            .sidebar-mobile {
                transform: translateX(0);
            }

            .main-content-mobile {
                margin-left: 0 !important;
            }
        }

        .loading-shimmer {
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite;
        }

        .dark .loading-shimmer {
            background: linear-gradient(90deg, #374151 25%, #4b5563 50%, #374151 75%);
            background-size: 200% 100%;
        }

        @keyframes shimmer {
            0% { background-position: -200% 0; }
            100% { background-position: 200% 0; }
        }

        /* Custom scrollbar for dark mode */
        .dark ::-webkit-scrollbar {
            width: 8px;
        }

        .dark ::-webkit-scrollbar-track {
            background: #1f2937;
        }

        .dark ::-webkit-scrollbar-thumb {
            background: #4b5563;
            border-radius: 4px;
        }

        .dark ::-webkit-scrollbar-thumb:hover {
            background: #6b7280;
        }

        /* Mobile specific styles */
        @media (max-width: 640px) {
            .sidebar-item {
                padding: 0.75rem 1rem;
            }

            .sidebar-item span {
                font-size: 0.875rem;
            }

            .glass-effect {
                backdrop-filter: blur(8px);
            }
        }
    </style>
</head>
<body class="font-sans antialiased bg-gray-50 dark:bg-gray-900 transition-colors duration-300">
    <!-- Mobile Overlay -->
    <div class="mobile-overlay lg:hidden" id="mobile-overlay"></div>

    <div class="min-h-screen">
        <!-- Sidebar -->
        <div class="fixed inset-y-0 left-0 w-72 bg-white dark:bg-gray-800 shadow-2xl dark:shadow-gray-900/50 sidebar-animate z-50 lg:translate-x-0 -translate-x-full transition-all duration-300" id="sidebar">
            <!-- Logo Section -->
            <div class="flex items-center justify-center h-20 gradient-bg">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-white dark:bg-gray-700 rounded-xl flex items-center justify-center">
                        <svg class="w-6 h-6 text-indigo-600 dark:text-indigo-400" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                        </svg>
                    </div>
                    <div>
                        <h1 class="text-xl font-bold text-white">Admin Panel</h1>
                        <p class="text-xs text-indigo-100 dark:text-gray-300">Management System</p>
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <nav class="mt-8 px-4 pb-4 overflow-y-auto max-h-[calc(100vh-5rem)]">
                <div class="space-y-2">
                    @php $isFullAccess = Auth::guard('admin')->user()->hasRole('full_access'); @endphp
                    <!-- Dashboard -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('dashboard.view'))
                    <a href="{{ route('admin.dashboard') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-indigo-50 hover:to-purple-50 dark:hover:from-indigo-900/50 dark:hover:to-purple-900/50 hover:text-indigo-700 dark:hover:text-indigo-300 transition-all duration-300 {{ request()->routeIs('admin.dashboard') ? 'bg-gradient-to-r from-indigo-50 to-purple-50 dark:from-indigo-900/50 dark:to-purple-900/50 text-indigo-700 dark:text-indigo-300 active' : '' }}">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-indigo-100 to-purple-100 dark:from-indigo-800/50 dark:to-purple-800/50 group-hover:from-indigo-200 group-hover:to-purple-200 dark:group-hover:from-indigo-700/50 dark:group-hover:to-purple-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-indigo-600 dark:text-indigo-400" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                            </svg>
                        </div>
                        <span>Dashboard</span>
                    </a>
                    @endif
                    <!-- Products -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('products.view'))
                    <a href="{{ route('admin.products.index') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-indigo-50 hover:to-purple-50 dark:hover:from-indigo-900/50 dark:hover:to-purple-900/50 hover:text-indigo-700 dark:hover:text-indigo-300 transition-all duration-300 {{ request()->routeIs('admin.products.*') ? 'bg-gradient-to-r from-indigo-50 to-purple-50 dark:from-indigo-900/50 dark:to-purple-900/50 text-indigo-700 dark:text-indigo-300 active' : '' }}">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-indigo-100 to-purple-100 dark:from-indigo-800/50 dark:to-purple-800/50 group-hover:from-indigo-200 group-hover:to-purple-200 dark:group-hover:from-indigo-700/50 dark:group-hover:to-purple-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-indigo-600 dark:text-indigo-400" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                            </svg>
                        </div>
                        <span>Products</span>
                    </a>
                    @endif
                    <!-- Newsletter Subscribers -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('newsletter.view'))
                    <a href="{{ route('admin.newsletter-subscribers.index') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-indigo-50 hover:to-purple-50 dark:hover:from-indigo-900/50 dark:hover:to-purple-900/50 hover:text-indigo-700 dark:hover:text-indigo-300 transition-all duration-300 {{ request()->routeIs('admin.newsletter-subscribers.index') ? 'bg-gradient-to-r from-indigo-50 to-purple-50 dark:from-indigo-900/50 dark:to-purple-900/50 text-indigo-700 dark:text-indigo-300 active' : '' }}">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-blue-100 to-purple-100 dark:from-blue-800/50 dark:to-purple-800/50 group-hover:from-blue-200 group-hover:to-purple-200 dark:group-hover:from-blue-700/50 dark:group-hover:to-purple-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                        </div>
                        <span>Newsletter Subscribers</span>
                    </a>
                    @endif
                    <!-- Orders -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('orders.view'))
                    <a href="{{ route('admin.orders.index') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-green-50 hover:to-teal-50 dark:hover:from-green-900/50 dark:hover:to-teal-900/50 hover:text-green-700 dark:hover:text-green-300 transition-all duration-300 {{ request()->routeIs('admin.orders.*') ? 'bg-gradient-to-r from-green-50 to-teal-50 dark:from-green-900/50 dark:to-teal-900/50 text-green-700 dark:text-green-300 active' : '' }}">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-green-100 to-teal-100 dark:from-green-800/50 dark:to-teal-800/50 group-hover:from-green-200 group-hover:to-teal-200 dark:group-hover:from-green-700/50 dark:group-hover:to-teal-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                        </div>
                        <span>Orders</span>
                    </a>
                    @endif
                    <!-- Users -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('users.view'))
                    <a href="{{ route('admin.users.index') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-purple-50 hover:to-pink-50 dark:hover:from-purple-900/50 dark:hover:to-pink-900/50 hover:text-purple-700 dark:hover:text-purple-300 transition-all duration-300 {{ request()->routeIs('admin.users.*') ? 'bg-gradient-to-r from-purple-50 to-pink-50 dark:from-purple-900/50 dark:to-pink-900/50 text-purple-700 dark:text-purple-300 active' : '' }}">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-purple-100 to-pink-100 dark:from-purple-800/50 dark:to-pink-800/50 group-hover:from-purple-200 group-hover:to-pink-200 dark:group-hover:from-purple-700/50 dark:group-hover:to-pink-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                            </svg>
                        </div>
                        <span>Users</span>
                    </a>
                    @endif
                    <!-- Admins -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('admins.view'))
                    <a href="{{ route('admin.admins.index') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-fuchsia-50 hover:to-pink-50 dark:hover:from-fuchsia-900/50 dark:hover:to-pink-900/50 hover:text-fuchsia-700 dark:hover:text-fuchsia-300 transition-all duration-300 {{ request()->routeIs('admin.admins.*') ? 'bg-gradient-to-r from-fuchsia-50 to-pink-50 dark:from-fuchsia-900/50 dark:to-pink-900/50 text-fuchsia-700 dark:text-fuchsia-300 active' : '' }}">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-fuchsia-100 to-pink-100 dark:from-fuchsia-800/50 dark:to-pink-800/50 group-hover:from-fuchsia-200 group-hover:to-pink-200 dark:group-hover:from-fuchsia-700/50 dark:group-hover:to-pink-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-fuchsia-600 dark:text-fuchsia-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a4 4 0 00-3-3.87M9 20H4v-2a4 4 0 013-3.87m9-4V7a4 4 0 10-8 0v3m12 4a4 4 0 01-3 3.87M6 16a4 4 0 01-3-3.87"/>
                            </svg>
                        </div>
                        <span>Admins</span>
                    </a>
                    @endif
                    <!-- Categories -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('categories.view'))
                    <a href="{{ route('admin.categories.index') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-orange-50 hover:to-red-50 dark:hover:from-orange-900/50 dark:hover:to-red-900/50 hover:text-orange-700 dark:hover:text-orange-300 transition-all duration-300 {{ request()->routeIs('admin.categories.*') ? 'bg-gradient-to-r from-orange-50 to-red-50 dark:from-orange-900/50 dark:to-red-900/50 text-orange-700 dark:text-orange-300 active' : '' }}">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-orange-100 to-red-100 dark:from-orange-800/50 dark:to-red-800/50 group-hover:from-orange-200 group-hover:to-red-200 dark:group-hover:from-orange-700/50 dark:group-hover:to-red-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-orange-600 dark:text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                            </svg>
                        </div>
                        <span>Categories</span>
                    </a>
                    @endif
                    <!-- Pages -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('pages.view'))
                    <a href="{{ route('admin.pages.index') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-yellow-50 hover:to-orange-50 dark:hover:from-yellow-900/50 dark:hover:to-orange-900/50 hover:text-yellow-700 dark:hover:text-yellow-300 transition-all duration-300 {{ request()->routeIs('admin.pages.*') ? 'bg-gradient-to-r from-yellow-50 to-orange-50 dark:from-yellow-900/50 dark:to-orange-900/50 text-yellow-700 dark:text-yellow-300 active' : '' }}">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-yellow-100 to-orange-100 dark:from-yellow-800/50 dark:to-orange-800/50 group-hover:from-yellow-200 group-hover:to-orange-200 dark:group-hover:from-yellow-700/50 dark:group-hover:to-orange-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-yellow-600 dark:text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                            </svg>
                        </div>
                        <span>Pages</span>
                    </a>
                    @endif
                    <!-- Contact Messages -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('contacts.view'))
                    <a href="{{ route('admin.contacts.index') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-indigo-50 hover:to-blue-50 dark:hover:from-indigo-900/50 dark:hover:to-blue-900/50 hover:text-indigo-700 dark:hover:text-indigo-300 transition-all duration-300 {{ request()->routeIs('admin.contacts.*') ? 'bg-gradient-to-r from-indigo-50 to-blue-50 dark:from-indigo-900/50 dark:to-blue-900/50 text-indigo-700 dark:text-indigo-300 active' : '' }} relative">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-indigo-100 to-blue-100 dark:from-indigo-800/50 dark:to-blue-800/50 group-hover:from-indigo-200 group-hover:to-blue-200 dark:group-hover:from-indigo-700/50 dark:group-hover:to-blue-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <span>Contact Messages</span>
                        @if($unreadContacts > 0)
                            <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-6 w-6 flex items-center justify-center font-bold text-[10px] notification-badge">
                                {{ $unreadContacts > 99 ? '99+' : $unreadContacts }}
                            </span>
                        @endif
                    </a>
                    @endif
                    <!-- Reviews -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('reviews.view'))
                    <a href="{{ route('admin.reviews.index') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-teal-50 hover:to-cyan-50 dark:hover:from-teal-900/50 dark:hover:to-cyan-900/50 hover:text-teal-700 dark:hover:text-teal-300 transition-all duration-300 {{ request()->routeIs('admin.reviews.*') ? 'bg-gradient-to-r from-teal-50 to-cyan-50 dark:from-teal-900/50 dark:to-cyan-900/50 text-teal-700 dark:text-teal-300 active' : '' }} relative">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-teal-100 to-cyan-100 dark:from-teal-800/50 dark:to-cyan-800/50 group-hover:from-teal-200 group-hover:to-cyan-200 dark:group-hover:from-teal-700/50 dark:group-hover:to-cyan-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-teal-600 dark:text-teal-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                            </svg>
                        </div>
                        <span>Reviews</span>
                        @if($pendingReviews > 0)
                            <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-6 w-6 flex items-center justify-center font-bold text-[10px] notification-badge">
                                {{ $pendingReviews > 99 ? '99+' : $pendingReviews }}
                            </span>
                        @endif
                    </a>
                    @endif
                    <!-- Chat Support -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('chats.view'))
                    <a href="{{ route('admin.chats') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-green-50 hover:to-emerald-50 dark:hover:from-green-900/50 dark:hover:to-emerald-900/50 hover:text-green-700 dark:hover:text-green-300 transition-all duration-300 {{ request()->routeIs('admin.chats') ? 'bg-gradient-to-r from-green-50 to-emerald-50 dark:from-green-900/50 dark:to-emerald-900/50 text-green-700 dark:text-green-300 active' : '' }} relative">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-green-100 to-emerald-100 dark:from-green-800/50 dark:to-emerald-800/50 group-hover:from-green-200 group-hover:to-emerald-200 dark:group-hover:from-green-700/50 dark:group-hover:to-emerald-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                            </svg>
                        </div>
                        <span>Chat Support</span>
                        <span class="admin-chat-alert-badge notification-badge absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-6 w-6 flex items-center justify-center font-bold text-[10px]" style="display: none;">0</span>
                    </a>
                    @endif
                    <!-- Settings -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('settings.view'))
                    <a href="{{ route('admin.settings.index') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-gray-50 hover:to-slate-50 dark:hover:from-gray-800/50 dark:hover:to-slate-800/50 hover:text-gray-700 dark:hover:text-gray-300 transition-all duration-300 {{ request()->routeIs('admin.settings.*') ? 'bg-gradient-to-r from-gray-50 to-slate-50 dark:from-gray-800/50 dark:to-slate-800/50 text-gray-700 dark:text-gray-300 active' : '' }}">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-gray-100 to-slate-100 dark:from-gray-700/50 dark:to-slate-700/50 group-hover:from-gray-200 group-hover:to-slate-200 dark:group-hover:from-gray-600/50 dark:group-hover:to-slate-600/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-gray-600 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                        </div>
                        <span>Settings</span>
                    </a>
                    @endif
                    <!-- Cooperation Requests -->
                    @if($isFullAccess || Auth::guard('admin')->user()->hasRole('cooperation-requests.view'))
                    <a href="{{ route('admin.cooperation-requests.index') }}" class="sidebar-item group flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-700 dark:text-gray-300 hover:bg-gradient-to-r hover:from-pink-50 hover:to-purple-50 dark:hover:from-pink-900/50 dark:hover:to-purple-900/50 hover:text-pink-700 dark:hover:text-pink-300 transition-all duration-300 {{ request()->routeIs('admin.cooperation-requests.*') ? 'bg-gradient-to-r from-pink-50 to-purple-50 dark:from-pink-900/50 dark:to-purple-900/50 text-pink-700 dark:text-pink-300 active' : '' }}">
                        <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-pink-100 to-purple-100 dark:from-pink-800/50 dark:to-purple-800/50 group-hover:from-pink-200 group-hover:to-purple-200 dark:group-hover:from-pink-700/50 dark:group-hover:to-purple-700/50 transition-all duration-300">
                            <svg class="w-5 h-5 text-pink-600 dark:text-pink-400" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/></svg>
                        </div>
                        <span>Cooperation Requests</span>
                    </a>
                    @endif
                </div>

                <!-- Logout Button -->
                <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                    <form method="POST" action="{{ route('admin.logout') }}">
                        @csrf
                        <button type="submit" class="sidebar-item group w-full flex items-center px-4 py-3 text-sm font-medium rounded-xl text-red-600 dark:text-red-400 hover:bg-gradient-to-r hover:from-red-50 hover:to-pink-50 dark:hover:from-red-900/50 dark:hover:to-pink-900/50 hover:text-red-700 dark:hover:text-red-300 transition-all duration-300">
                            <div class="mr-3 p-2 rounded-lg bg-gradient-to-br from-red-100 to-pink-100 dark:from-red-800/50 dark:to-pink-800/50 group-hover:from-red-200 group-hover:to-pink-200 dark:group-hover:from-red-700/50 dark:group-hover:to-pink-700/50 transition-all duration-300">
                                <svg class="w-5 h-5 text-red-600 dark:text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                                </svg>
                            </div>
                            <span>Logout</span>
                        </button>
                    </form>
                </div>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="lg:ml-72 main-content-animate min-h-screen">
            <!-- Top Navigation -->
            <header class="glass-effect border-b border-gray-200 dark:border-gray-700 sticky top-0 z-30">
                <div class="px-4 sm:px-6 lg:px-8">
                    <div class="flex justify-between items-center h-16">
                        <div class="flex items-center">
                            <button type="button" class="lg:hidden p-2 rounded-lg text-gray-500 dark:text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-indigo-500 dark:focus:ring-indigo-400 transition-all duration-200" id="sidebar-toggle">
                                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                                </svg>
                            </button>
                            <div class="ml-4 lg:ml-0">
                                <h1 class="text-xl font-semibold text-gray-900 dark:text-white">Admin Dashboard</h1>
                                <p class="text-sm text-gray-500 dark:text-gray-400">Manage your application</p>
                            </div>
                        </div>

                        <div class="flex items-center space-x-4">
                            <!-- Dark mode toggle -->
                            <button type="button" class="p-2 rounded-lg text-gray-500 dark:text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-indigo-500 transition-all duration-200" onclick="toggleDarkMode()">
                                <svg class="w-5 h-5 hidden dark:block" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.12-10.607a1 1 0 010 1.414l-.706.707a1 1 0 11-1.414-1.414l.707-.707a1 1 0 011.414 0zM17 11a1 1 0 100-2h-1a1 1 0 100 2h1zm-7 4a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM5.05 6.464A1 1 0 106.465 5.05l-.708-.707a1 1 0 00-1.414 1.414l.707.707zm1.414 8.486l-.707.707a1 1 0 01-1.414-1.414l.707-.707a1 1 0 011.414 1.414zM4 11a1 1 0 100-2H3a1 1 0 000 2h1z" clip-rule="evenodd"/>
                                </svg>
                                <svg class="w-5 h-5 block dark:hidden" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M17.293 13.293A8 8 0 016.707 2.707a8.001 8.001 0 1010.586 10.586z"/>
                                </svg>
                            </button>

                            <!-- Notifications -->
                            <div class="relative">
                                <button class="p-2 rounded-lg text-gray-500 dark:text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-indigo-500 transition-all duration-200">
                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5 5v-5zM9 7v10l5-5-5-5z"/>
                                    </svg>
                                </button>
                                <span class="absolute top-0 right-0 block h-2 w-2 rounded-full bg-red-400 ring-2 ring-white dark:ring-gray-800"></span>
                            </div>

                            <!-- User Profile -->
                            <div class="flex items-center space-x-3">
                                <div class="w-8 h-8 rounded-full bg-gradient-to-br from-indigo-500 to-purple-600 flex items-center justify-center">
                                    <span class="text-sm font-medium text-white">{{ substr(Auth::guard('admin')->user()->name, 0, 1) }}</span>
                                </div>
                                <div class="hidden sm:block">
                                    <p class="text-sm font-medium text-gray-900 dark:text-white">{{ Auth::guard('admin')->user()->name }}</p>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">
                                        Administrator
                                        @if(Auth::guard('admin')->user()->hasRole('full_access'))
                                            <span class="ml-2 px-2 py-0.5 bg-green-100 text-green-800 text-xs font-bold rounded">Full Access</span>
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </header>
            </header>

            <!-- Page Content -->
            <main class="flex-1">
                <div class="py-6">
                    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                        <!-- Success Messages -->
                        @if (session('success'))
                            <div class="mb-6 p-4 bg-gradient-to-r from-green-50 to-emerald-50 dark:from-green-900/20 dark:to-emerald-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 rounded-xl shadow-sm animate-fade-in">
                                <div class="flex items-center">
                                    <svg class="w-5 h-5 mr-3 text-green-600 dark:text-green-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                    </svg>
                                    {{ session('success') }}
                                </div>
                            </div>
                        @endif

                        <!-- Error Messages -->
                        @if (session('error'))
                            <div class="mb-6 p-4 bg-gradient-to-r from-red-50 to-pink-50 dark:from-red-900/20 dark:to-pink-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 rounded-xl shadow-sm animate-fade-in">
                                <div class="flex items-center">
                                    <svg class="w-5 h-5 mr-3 text-red-600 dark:text-red-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                                    </svg>
                                    {{ session('error') }}
                                </div>
                            </div>
                        @endif

                        {{ $slot }}
                    </div>
                </div>
            </main>
        </div>
    </div>
    @include('admin.layouts.scripts')
    @stack('scripts')
</body>
</html>
