<!-- jQuery -->
<script src="{{ asset('global/js/jquery-3.6.0.min.js') }}"></script>
<script src="{{ asset('global/js/pusher.min.js') }}"></script>
<script src="{{ asset('global/js/echo.iife.js') }}"></script>
<script src="{{ asset('admin/js/global.js') }}"></script>

<script>
// Mobile sidebar toggle functionality
document.addEventListener('DOMContentLoaded', function() {
    const sidebar = document.getElementById('sidebar');
    const sidebarToggle = document.getElementById('sidebar-toggle');
    const mobileOverlay = document.getElementById('mobile-overlay');
    const mainContent = document.querySelector('.main-content-animate');

    // Toggle sidebar on mobile
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', function() {
            sidebar.classList.toggle('-translate-x-full');
            mobileOverlay.classList.toggle('active');
            document.body.classList.toggle('overflow-hidden');
        });
    }

    // Close sidebar when clicking overlay
    if (mobileOverlay) {
        mobileOverlay.addEventListener('click', function() {
            sidebar.classList.add('-translate-x-full');
            mobileOverlay.classList.remove('active');
            document.body.classList.remove('overflow-hidden');
        });
    }

    // Close sidebar when clicking outside on mobile
    document.addEventListener('click', function(e) {
        if (window.innerWidth < 1024) {
            if (!sidebar.contains(e.target) && !sidebarToggle.contains(e.target)) {
                sidebar.classList.add('-translate-x-full');
                mobileOverlay.classList.remove('active');
                document.body.classList.remove('overflow-hidden');
            }
        }
    });

    // Handle window resize
    window.addEventListener('resize', function() {
        if (window.innerWidth >= 1024) {
            sidebar.classList.remove('-translate-x-full');
            mobileOverlay.classList.remove('active');
            document.body.classList.remove('overflow-hidden');
        } else {
            sidebar.classList.add('-translate-x-full');
        }
    });
});

// Orders dropdown functionality
document.addEventListener('DOMContentLoaded', function() {
    const ordersDropdown = document.getElementById('orders-dropdown');
    const ordersSubmenu = document.getElementById('orders-submenu');
    const dropdownArrow = ordersDropdown?.querySelector('svg:last-child');

    if (ordersDropdown && ordersSubmenu) {
        // Check if current page is in orders section and open submenu
        if (window.location.pathname.includes('/admin/orders')) {
            ordersSubmenu.classList.remove('hidden');
            if (dropdownArrow) {
                dropdownArrow.classList.add('rotate-180');
            }
        }

        ordersDropdown.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();

            const isOpen = !ordersSubmenu.classList.contains('hidden');

            if (isOpen) {
                ordersSubmenu.classList.add('hidden');
                if (dropdownArrow) {
                    dropdownArrow.classList.remove('rotate-180');
                }
            } else {
                ordersSubmenu.classList.remove('hidden');
                if (dropdownArrow) {
                    dropdownArrow.classList.add('rotate-180');
                }
            }
        });
    }

    // Close submenu when clicking outside
    document.addEventListener('click', function(e) {
        if (!ordersDropdown?.contains(e.target)) {
            if (ordersSubmenu && !ordersSubmenu.classList.contains('hidden')) {
                ordersSubmenu.classList.add('hidden');
                if (dropdownArrow) {
                    dropdownArrow.classList.remove('rotate-180');
                }
            }
        }
    });
});

// Dark mode toggle functionality
function toggleDarkMode() {
    const html = document.documentElement;
    const isDark = html.classList.contains('dark');

    if (isDark) {
        html.classList.remove('dark');
        localStorage.setItem('darkMode', 'light');
    } else {
        html.classList.add('dark');
        localStorage.setItem('darkMode', 'dark');
    }
}

// Initialize dark mode from localStorage
document.addEventListener('DOMContentLoaded', function() {
    const darkMode = localStorage.getItem('darkMode');
    const html = document.documentElement;

    if (darkMode === 'dark' || (!darkMode && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
        html.classList.add('dark');
    } else {
        html.classList.remove('dark');
    }
});
</script>

{{-- دکمه و فرم افزودن نقش جدید به صفحه مدیریت نقش‌ها اضافه شد --}}
