<x-admin-layout>
    <div class="container mx-auto py-8 bg-slate-600 p-4 rounded-md">
        <h1 class="text-2xl font-bold mb-6">Newsletter Subscribers</h1>
        <div class="bg-white shadow rounded-lg overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">#</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Emails Sent</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Subscribed At</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Last Updated</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($subscribers as $i => $subscriber)
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $subscribers->firstItem() + $i }}</td>
                        <td class="px-6 py-4 whitespace-nowrap font-mono">{{ $subscriber->email }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">{{ $subscriber->emails_sent }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $subscriber->created_at->format('Y-m-d H:i') }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $subscriber->updated_at->format('Y-m-d H:i') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="mt-6">
            {{ $subscribers->links() }}
        </div>
    </div>
</x-admin-layout>
