
<x-admin-layout>
    <div class="container mx-auto px-4 py-8 bg-slate-600 p-4 rounded-md">
        <!-- Header Section -->
        <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center mb-6 gap-4">
            <h1 class="text-2xl md:text-3xl font-bold text-gray-900 dark:text-white">All Orders</h1>
            <div class="flex flex-col sm:flex-row gap-2 sm:gap-4">
                <a href="{{ route('admin.orders.approved') }}"
                   class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded-lg text-center transition-colors duration-200 text-sm sm:text-base">
                    Approved Orders
                </a>
                <a href="{{ route('admin.orders.shipped') }}"
                   class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg text-center transition-colors duration-200 text-sm sm:text-base">
                    Shipped Orders
                </a>
            </div>
        </div>

        <!-- Success/Error Messages -->
        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                {{ session('success') }}
            </div>
        @endif

        @if(session('error'))
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                {{ session('error') }}
            </div>
        @endif

        <!-- Desktop Table View -->
        <div class="hidden lg:block bg-white dark:bg-gray-800 rounded-lg shadow overflow-hidden">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Order ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Customer</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Total</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @foreach($orders as $order)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-150">
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                #{{ $order->id }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                {{ $order->first_name }} {{ $order->last_name }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                    @if($order->status === 'delivered') bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-100
                                    @elseif($order->status === 'shipped') bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-100
                                    @elseif($order->status === 'approved') bg-yellow-100 text-yellow-800 dark:bg-yellow-800 dark:text-yellow-100
                                    @elseif($order->status === 'pending') bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-100
                                    @elseif($order->status === 'cancelled') bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-100
                                    @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-100
                                    @endif">
                                    {{ ucfirst($order->status) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                ${{ number_format($order->total_amount, 2) }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                {{ $order->created_at->format('M d, Y') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <div class="flex items-center space-x-3">
                                    <a href="{{ route('admin.orders.show', $order) }}"
                                       class="text-blue-600 hover:text-blue-900 dark:text-blue-400 dark:hover:text-blue-300 transition-colors duration-150">
                                        View Details
                                    </a>
                                    @if($order->status === 'pending')
                                        <form action="{{ route('admin.orders.approve', $order) }}" method="POST" class="inline">
                                            @csrf
                                            <button type="submit"
                                                    class="bg-green-500 hover:bg-green-600 text-white px-3 py-1 rounded text-sm transition-colors duration-150">
                                                Approve
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Mobile Card View -->
        <div class="lg:hidden space-y-4">
            @foreach($orders as $order)
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 border border-gray-200 dark:border-gray-700">
                    <!-- Order Header -->
                    <div class="flex justify-between items-start mb-3">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Order #{{ $order->id }}</h3>
                            <p class="text-sm text-gray-600 dark:text-gray-400">{{ $order->first_name }} {{ $order->last_name }}</p>
                        </div>
                        <span class="px-2 py-1 text-xs font-semibold rounded-full
                            @if($order->status === 'delivered') bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-100
                            @elseif($order->status === 'shipped') bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-100
                            @elseif($order->status === 'approved') bg-yellow-100 text-yellow-800 dark:bg-yellow-800 dark:text-yellow-100
                            @elseif($order->status === 'pending') bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-100
                            @elseif($order->status === 'cancelled') bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-100
                            @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-100
                            @endif">
                            {{ ucfirst($order->status) }}
                        </span>
                    </div>

                    <!-- Order Details -->
                    <div class="grid grid-cols-2 gap-3 mb-4">
                        <div>
                            <p class="text-xs text-gray-500 dark:text-gray-400 uppercase tracking-wider">Total Amount</p>
                            <p class="text-lg font-semibold text-gray-900 dark:text-white">${{ number_format($order->total_amount, 2) }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 dark:text-gray-400 uppercase tracking-wider">Order Date</p>
                            <p class="text-sm text-gray-900 dark:text-white">{{ $order->created_at->format('M d, Y') }}</p>
                        </div>
                    </div>

                    <!-- Actions -->
                    <div class="flex flex-col sm:flex-row gap-2">
                        <a href="{{ route('admin.orders.show', $order) }}"
                           class="flex-1 bg-blue-500 hover:bg-blue-600 text-white text-center px-4 py-2 rounded-lg text-sm transition-colors duration-150">
                            View Details
                        </a>
                        @if($order->status === 'pending')
                            <form action="{{ route('admin.orders.approve', $order) }}" method="POST" class="flex-1">
                                @csrf
                                <button type="submit"
                                        class="w-full bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded-lg text-sm transition-colors duration-150">
                                    Approve Order
                                </button>
                            </form>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Pagination -->
        @if($orders->hasPages())
            <div class="mt-6">
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-4">
                    {{ $orders->links() }}
                </div>
            </div>
        @endif

        <!-- Empty State -->
        @if($orders->isEmpty())
            <div class="text-center py-12">
                <div class="mx-auto w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-4">
                    <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                    </svg>
                </div>
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-2">No Orders Found</h3>
                <p class="text-gray-500 dark:text-gray-400">No orders have been placed yet.</p>
            </div>
        @endif
    </div>

    <style>
        /* Custom responsive styles */
        @media (max-width: 640px) {
            .container {
                padding-left: 1rem;
                padding-right: 1rem;
            }
        }

        /* Dark mode scrollbar */
        @media (prefers-color-scheme: dark) {
            ::-webkit-scrollbar {
                width: 8px;
            }

            ::-webkit-scrollbar-track {
                background: #374151;
            }

            ::-webkit-scrollbar-thumb {
                background: #6b7280;
                border-radius: 4px;
            }

            ::-webkit-scrollbar-thumb:hover {
                background: #9ca3af;
            }
        }

        /* Improved button hover states */
        .transition-colors {
            transition-property: background-color, border-color, color;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
            transition-duration: 150ms;
        }
    </style>
</x-admin-layout>
