
@php
    use App\Models\Setting;
@endphp

<x-admin-layout>
    <div class="container mx-auto px-2 sm:px-4 py-4 sm:py-8 bg-slate-300 p-4 rounded-md">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 space-y-4 sm:space-y-0">
            <h1 class="text-xl sm:text-2xl font-bold">Order #{{ $order->id }}</h1>
            <a href="{{ route('admin.orders.index') }}" class="text-blue-600 hover:text-blue-900 text-sm sm:text-base transition-colors duration-200">
                ← Back to Orders
            </a>
        </div>

        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-3 sm:px-4 py-3 rounded mb-4 text-sm sm:text-base">
                {{ session('success') }}
            </div>
        @endif

        @if(session('error'))
            <div class="bg-red-100 border border-red-400 text-red-700 px-3 sm:px-4 py-3 rounded mb-4 text-sm sm:text-base">
                {{ session('error') }}
            </div>
        @endif

        <!-- Order Status Banner -->
        <div class="bg-white rounded-lg shadow mb-4 sm:mb-6">
            <div class="px-3 sm:px-6 py-4 border-b">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between space-y-4 lg:space-y-0">
                    <h2 class="text-lg font-semibold">Order Status</h2>
                    <form action="{{ route('admin.orders.update-status', $order) }}" method="POST" class="flex flex-col sm:flex-row items-start sm:items-center space-y-2 sm:space-y-0 sm:space-x-4">
                        @csrf
                        @method('PUT')
                        <select name="status" class="w-full sm:w-auto rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm transition-colors duration-200">
                            <option value="pending" {{ $order->status === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="approved" {{ $order->status === 'approved' ? 'selected' : '' }}>Approved</option>
                            <option value="shipped" {{ $order->status === 'shipped' ? 'selected' : '' }}>Shipped</option>
                            <option value="delivered" {{ $order->status === 'delivered' ? 'selected' : '' }}>Delivered</option>
                            <option value="cancelled" {{ $order->status === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                        <button type="submit" class="w-full sm:w-auto bg-blue-500 hover:bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-lg text-sm transition-colors duration-200">
                            Update Status
                        </button>
                    </form>
                </div>
            </div>

            <!-- Status-based Action Sections -->
            @if($order->status === 'pending')
                <div class="px-3 sm:px-6 py-4 bg-yellow-50 border-t">
                    <div class="flex flex-col sm:flex-row items-start sm:items-center space-y-2 sm:space-y-0 sm:space-x-4">
                        <div class="flex-1">
                            <p class="text-sm text-yellow-800">Order is waiting for approval.</p>
                        </div>
                        <form action="{{ route('admin.orders.approve', $order) }}" method="POST" class="inline">
                            @csrf
                            <button type="submit" class="w-full sm:w-auto bg-green-500 hover:bg-green-600 text-white px-3 sm:px-4 py-2 rounded-lg text-sm transition-colors duration-200">
                                ✓ Approve for Shipping
                            </button>
                        </form>
                    </div>
                </div>
            @endif

            @if($order->status === 'approved')
                <div class="px-3 sm:px-6 py-4 bg-green-50 border-t">
                    <form action="{{ route('admin.orders.ship', $order) }}" method="POST" class="space-y-4">
                        @csrf
                        <div class="flex flex-col sm:flex-row items-start sm:items-center space-y-2 sm:space-y-0 sm:space-x-4">
                            <input type="text" name="tracking_number" placeholder="Enter tracking number" required
                                   class="flex-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 text-sm transition-colors duration-200">
                            <button type="submit" class="w-full sm:w-auto bg-blue-500 hover:bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-lg text-sm transition-colors duration-200">
                                🚚 Mark as Shipped
                            </button>
                        </div>
                    </form>
                </div>
            @endif

            @if($order->status === 'shipped')
                <div class="px-3 sm:px-6 py-4 bg-blue-50 border-t">
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between space-y-4 lg:space-y-0">
                        <div class="space-y-1">
                            <p class="text-sm text-gray-600">
                                Tracking Number:
                                <span class="font-medium font-mono bg-white px-2 py-1 rounded border">{{ $order->tracking_number }}</span>
                            </p>
                            <p class="text-sm text-gray-600">
                                Shipped on:
                                <span class="font-medium">{{ $order->shipping_date ? $order->shipping_date->format('M d, Y H:i') : 'N/A' }}</span>
                            </p>
                        </div>
                        <form action="{{ route('admin.orders.deliver', $order) }}" method="POST" class="inline">
                            @csrf
                            <button type="submit" class="w-full sm:w-auto bg-green-500 hover:bg-green-600 text-white px-3 sm:px-4 py-2 rounded-lg text-sm transition-colors duration-200">
                                📦 Mark as Delivered
                            </button>
                        </form>
                    </div>
                </div>
            @endif

            @if($order->status === 'delivered')
                <div class="px-3 sm:px-6 py-4 bg-green-50 border-t">
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between space-y-4 lg:space-y-0">
                        <div class="space-y-1">
                            <p class="text-sm text-gray-600">
                                Tracking Number:
                                <span class="font-medium font-mono bg-white px-2 py-1 rounded border">{{ $order->tracking_number }}</span>
                            </p>
                            <p class="text-sm text-gray-600">
                                Delivered on:
                                <span class="font-medium">{{ $order->delivery_date ? $order->delivery_date->format('M d, Y H:i') : 'N/A' }}</span>
                            </p>
                        </div>
                        <span class="inline-flex items-center text-green-600 font-medium">
                            <svg class="w-5 h-5 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                            </svg>
                            Order Completed
                        </span>
                    </div>
                </div>
            @endif

            @if($order->status === 'cancelled')
                <div class="px-3 sm:px-6 py-4 bg-red-50 border-t">
                    <div class="flex items-center space-x-2">
                        <svg class="w-5 h-5 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                        </svg>
                        <span class="text-red-600 font-medium">Order Cancelled</span>
                    </div>
                </div>
            @endif
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 sm:gap-6">
            <!-- Order Summary -->
            <div class="bg-white rounded-lg shadow">
                <div class="px-3 sm:px-6 py-4 border-b">
                    <h2 class="text-lg font-semibold">Order Summary</h2>
                </div>
                <div class="p-3 sm:p-6">
                    <div class="space-y-3 sm:space-y-4">
                        <div class="flex justify-between text-sm sm:text-base">
                            <span class="text-gray-600">Order Date:</span>
                            <span class="font-medium">{{ $order->created_at->format('M d, Y H:i') }}</span>
                        </div>
                        <div class="flex justify-between text-sm sm:text-base">
                            <span class="text-gray-600">Subtotal:</span>
                            <span class="font-medium">${{ number_format($subtotal, 2) }}</span>
                        </div>
                        <div class="flex justify-between text-sm sm:text-base">
                            <span class="text-gray-600">Tax ({{ number_format(Setting::getTaxRate() * 100, 0) }}%):</span>
                            <span class="font-medium">${{ number_format($tax, 2) }}</span>
                        </div>
                        <div class="flex justify-between text-sm sm:text-base border-t pt-2">
                            <span class="text-gray-600 font-semibold">Total Amount:</span>
                            <span class="font-bold text-lg">${{ number_format($total, 2) }}</span>
                        </div>
                        <div class="flex justify-between text-sm sm:text-base">
                            <span class="text-gray-600">Payment Method:</span>
                            <span class="font-medium">{{ ucfirst($order->payment_method) }}</span>
                        </div>
                        <div class="flex justify-between items-center text-sm sm:text-base">
                            <span class="text-gray-600">Status:</span>
                            <span class="px-2 py-1 text-xs font-semibold rounded-full
                                @if($order->status === 'pending') bg-yellow-100 text-yellow-800
                                @elseif($order->status === 'approved') bg-blue-100 text-blue-800
                                @elseif($order->status === 'shipped') bg-purple-100 text-purple-800
                                @elseif($order->status === 'delivered') bg-green-100 text-green-800
                                @elseif($order->status === 'cancelled') bg-red-100 text-red-800
                                @endif">
                                {{ ucfirst($order->status) }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer Information -->
            <div class="bg-white rounded-lg shadow">
                <div class="px-3 sm:px-6 py-4 border-b">
                    <h2 class="text-lg font-semibold">Customer Information</h2>
                </div>
                <div class="p-3 sm:p-6">
                    <div class="space-y-3 sm:space-y-4">
                        <div class="text-sm sm:text-base">
                            <span class="text-gray-600">Name:</span>
                            <span class="font-medium ml-2">{{ $order->first_name }} {{ $order->last_name }}</span>
                        </div>
                        <div class="text-sm sm:text-base">
                            <span class="text-gray-600">Email:</span>
                            <a href="mailto:{{ $order->email }}" class="font-medium ml-2 break-all text-blue-600 hover:text-blue-800 transition-colors duration-200">{{ $order->email }}</a>
                        </div>
                        <div class="text-sm sm:text-base">
                            <span class="text-gray-600">Phone:</span>
                            <a href="tel:{{ $order->phone }}" class="font-medium ml-2 text-blue-600 hover:text-blue-800 transition-colors duration-200">{{ $order->phone }}</a>
                        </div>
                        @if($order->user)
                        <div class="text-sm sm:text-base">
                            <span class="text-gray-600">User Account:</span>
                            <div class="ml-2 mt-1">
                                <span class="font-medium">{{ $order->user->name }}</span>
                                <div class="text-xs text-gray-500 break-all">{{ $order->user->email }}</div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Shipping Information -->
        <div class="bg-white rounded-lg shadow mt-4 sm:mt-6">
            <div class="px-3 sm:px-6 py-4 border-b">
                <h2 class="text-lg font-semibold">Shipping Information</h2>
            </div>
            <div class="p-3 sm:p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
                    <div>
                        <h3 class="text-sm font-medium text-gray-500 mb-2">Shipping Address</h3>
                        <div class="space-y-1 text-sm sm:text-base">
                            <p class="font-medium">{{ $order->shipping_address }}</p>
                            <p class="text-gray-600">{{ $order->city }}, {{ $order->country }}</p>
                        </div>
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-500 mb-2">Order Notes</h3>
                        <p class="text-sm sm:text-base bg-gray-50 p-3 rounded-lg">
                            {{ $order->order_notes ?: 'No notes provided' }}
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Order Items -->
        <div class="bg-white rounded-lg shadow mt-4 sm:mt-6">
            <div class="px-3 sm:px-6 py-4 border-b">
                <h2 class="text-lg font-semibold">Order Items ({{ $order->items->count() }} items)</h2>
            </div>
            <div class="p-3 sm:p-6">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="hidden sm:table-header-group bg-gray-50">
                            <tr>
                                <th class="px-2 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Product</th>
                                <th class="px-2 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Price</th>
                                <th class="px-2 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Quantity</th>
                                <th class="px-2 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($order->items as $item)
                                <tr class="sm:table-row block border-b sm:border-b-0 pb-4 sm:pb-0 mb-4 sm:mb-0 hover:bg-gray-50">
                                    <td class="px-2 sm:px-6 py-2 sm:py-4 sm:whitespace-nowrap block sm:table-cell">
                                        <div class="flex items-start sm:items-center">
                                            <div class="h-12 w-12 sm:h-10 sm:w-10 flex-shrink-0">
                                                @if($item->product)
                                                    @php
                                                        $images = is_string($item->product->image) ? json_decode($item->product->image, true) : $item->product->image;
                                                        $firstImage = !empty($images) ? $images[0] : null;
                                                    @endphp
                                                    @if($firstImage)
                                                        <img class="h-12 w-12 sm:h-10 sm:w-10 rounded-lg sm:rounded-full object-cover border" src="{{ asset('/' . $firstImage) }}" alt="{{ $item->product->name }}">
                                                    @else
                                                        <div class="h-12 w-12 sm:h-10 sm:w-10 rounded-lg sm:rounded-full bg-gray-200 flex items-center justify-center border">
                                                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                                            </svg>
                                                        </div>
                                                    @endif
                                                @else
                                                    <div class="h-12 w-12 sm:h-10 sm:w-10 rounded-lg sm:rounded-full bg-red-200 flex items-center justify-center border border-red-300">
                                                        <svg class="w-6 h-6 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"/>
                                                        </svg>
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="ml-3 sm:ml-4 flex-1">
                                                <div class="text-sm font-medium text-gray-900">
                                                    @if($item->product)
                                                        {{ $item->product->name }}
                                                    @else
                                                        <span class="text-red-500">⚠️ Product Deleted</span>
                                                    @endif
                                                </div>

                                                <!-- Mobile: Show price, quantity, total inline -->
                                                <div class="sm:hidden text-xs text-gray-500 mt-1 space-y-1">
                                                    <div>Price: ${{ number_format($item->price, 2) }}</div>
                                                    <div>Qty: {{ $item->quantity }}</div>
                                                    <div class="font-medium">Total: ${{ number_format($item->price * $item->quantity, 2) }}</div>
                                                </div>

                                                @if($item->additional_price > 0)
                                                    <div class="text-xs text-green-600 mt-1">+${{ number_format($item->additional_price, 2) }} options</div>
                                                @endif
                                                @if($item->dynamic_selections)
                                                    @php
                                                        $selections = is_string($item->dynamic_selections) ? json_decode($item->dynamic_selections, true) : $item->dynamic_selections;
                                                    @endphp
                                                    @if($selections && is_array($selections))
                                                        <div class="text-xs text-gray-500 mt-1 bg-gray-50 p-2 rounded">
                                                            @foreach($selections as $fieldName => $selection)
                                                                @if(is_array($selection) && isset($selection['value']))
                                                                    <div>{{ $fieldName }}: {{ $selection['value'] }}</div>
                                                                @elseif(is_string($selection))
                                                                    <div>{{ $fieldName }}: {{ $selection }}</div>
                                                                @endif
                                                            @endforeach
                                                        </div>
                                                    @endif
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-2 sm:px-6 py-2 sm:py-4 sm:whitespace-nowrap text-sm text-gray-900 font-medium hidden sm:table-cell">
                                        ${{ number_format($item->price, 2) }}
                                    </td>
                                    <td class="px-2 sm:px-6 py-2 sm:py-4 sm:whitespace-nowrap text-sm text-gray-900 hidden sm:table-cell">
                                        {{ $item->quantity }}
                                    </td>
                                    <td class="px-2 sm:px-6 py-2 sm:py-4 sm:whitespace-nowrap text-sm text-gray-900 font-medium hidden sm:table-cell">
                                        ${{ number_format($item->price * $item->quantity, 2) }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="hidden sm:table-footer-group bg-gray-50">
                            <tr>
                                <td colspan="3" class="px-6 py-4 text-right text-sm font-medium text-gray-900">Subtotal:</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">${{ number_format($subtotal, 2) }}</td>
                            </tr>
                            <tr>
                                <td colspan="3" class="px-6 py-4 text-right text-sm font-medium text-gray-900">Tax ({{ number_format(Setting::getTaxRate() * 100, 0) }}%):</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">${{ number_format($tax, 2) }}</td>
                            </tr>
                            <tr class="bg-gray-100">
                                <td colspan="3" class="px-6 py-4 text-right text-base font-bold text-gray-900">Total:</td>
                                <td class="px-6 py-4 whitespace-nowrap text-base font-bold text-gray-900">${{ number_format($total, 2) }}</td>
                            </tr>
                        </tfoot>
                    </table>

                    <!-- Mobile totals -->
                    <div class="sm:hidden mt-4 pt-4 border-t space-y-2 bg-gray-50 p-3 rounded-lg">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Subtotal:</span>
                            <span class="font-medium">${{ number_format($subtotal, 2) }}</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Tax ({{ number_format(Setting::getTaxRate() * 100, 0) }}%):</span>
                            <span class="font-medium">${{ number_format($tax, 2) }}</span>
                        </div>
                        <div class="flex justify-between text-base font-bold pt-2 border-t">
                            <span>Total:</span>
                            <span>${{ number_format($total, 2) }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="mt-6 flex flex-col sm:flex-row gap-3 sm:gap-4">
            <a href="{{ route('admin.orders.index') }}" class="flex-1 sm:flex-none bg-gray-500 hover:bg-gray-600 text-white px-6 py-3 rounded-lg text-center font-medium transition-colors duration-200">
                ← Back to Orders
            </a>
            <button onclick="window.print()" class="flex-1 sm:flex-none bg-blue-500 hover:bg-blue-600 text-white px-6 py-3 rounded-lg font-medium transition-colors duration-200">
                🖨️ Print Order
            </button>
        </div>
    </div>

    <style>
        @media print {
            .no-print {
                display: none !important;
            }
            body {
                background: white !important;
            }
            .shadow, .shadow-lg {
                box-shadow: none !important;
            }
        }
    </style>
</x-admin-layout>
